%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		groundedice_levelset = NaN;
		ice_levelset         = NaN;
	end
	methods (Static)
		function self = loadobj(self) % {{{
			% This function is directly called by matlab when a model object is
			% loaded. Update old properties here

			%2014 February 5th
			if numel(self.ice_levelset)>1 & all(self.ice_levelset>=0),
				disp('WARNING: md.mask.ice_levelset>=0, you probably need to change the sign of this levelset');
			end

		end% }}}
	end
	methods
		function self = extrude(self,md) % {{{
			self.groundedice_levelset=project3d(md,'vector',self.groundedice_levelset,'type','node');
			self.ice_levelset=project3d(md,'vector',self.ice_levelset,'type','node');
		end % }}}
		function self = mask(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','mask.groundedice_levelset','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','mask.ice_levelset','forcing',1);
			isice=(md.mask.ice_levelset<=0);
			if sum(isice)==0,
				warning('no ice present in the domain');
			end
			if max(md.mask.ice_levelset)<0,
				warning('no ice front provided');
			end
			icefront=sum(md.mask.ice_levelset(md.mesh.elements)==0,2);
			if (max(icefront)==3 & strcmp(elementtype(md.mesh),'Tria')) | (max(icefront==6) & strcmp(elementtype(md.mesh),'Penta')),
				error('At least one element has all nodes on ice front, change md.mask.ice_levelset to fix it')
			end
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   masks:'));

			fielddisplay(self,'groundedice_levelset','is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0');
			fielddisplay(self,'ice_levelset','presence of ice if < 0, icefront position if = 0, no ice if > 0');
		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1);
			WriteData(fid,'object',self,'fieldname','ice_levelset','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);

			% get mask of vertices of elements with ice
			if size(md.mask.ice_levelset,1)==md.mesh.numberofvertices,
				isice=md.mask.ice_levelset<=0.;
				vlist = zeros(md.mesh.numberofvertices,1);
				pos=find(sum(isice(md.mesh.elements),2)>0);
				vlist(md.mesh.elements(pos,:))=1;
				WriteData(fid,'data',vlist,'enum',IceMaskNodeActivationEnum(),'format','DoubleMat','mattype',1);
			else
				isice=md.mask.ice_levelset(1:end-1,1)<=0.;
				vlist = zeros(md.mesh.numberofvertices,1);
				pos=find(sum(isice(md.mesh.elements),2)>0);
				vlist(md.mesh.elements(pos,:))=1;
				WriteData(fid,'data',vlist,'enum',IceMaskNodeActivationEnum(),'format','DoubleMat','mattype',1);
			end

		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
		
			writejs1Darray(fid,[modelname '.mask.groundedice_levelset'],self.groundedice_levelset);
			writejs2Darray(fid,[modelname '.mask.ice_levelset'],self.ice_levelset);

		end % }}}
	end
end
