function mh=patchglobe(mh,mh2d,varargin)

	%process options: 
	options=pairoptions(varargin{:});

	%recover basic options:
	hem=getfieldvalue(options,'hem');
	bandwidth=getfieldvalue(options,'bandwidth',100000);

	%give ourselves a unique temporary directory: 
	temproot=tempname; mkdir(temproot);

	%figure out domain outline: 
	meshtodomain(mh2d,[temproot '/Patch.exp']);

	%broaden this domain outline: 
	expcoarsen([temproot '/PatchBroad.exp'],[temproot '/Patch.exp'],200000);
	expcontract([temproot '/PatchBroad.exp'],[temproot '/PatchBroad.exp'],-bandwidth);

	%now flag vertices that are within the contour:
	[x,y]=ll2xy(mh.lat,mh.long,hem);
	if hem==1,
		flagsnods=ContourToNodes(x,y,[temproot '/PatchBroad.exp'],1) & mh.lat>=0;
	else
		flagsnods=ContourToNodes(x,y,[temproot '/PatchBroad.exp'],1) & mh.lat<=0;
	end

	%expand flags to any element that touches the contour: 
	pos=find(sum(flagsnods(mh.elements),2));
	flags=zeros(mh.numberofelements,1); flags(pos)=1;

	%need to find the segment enveloppe of these elements:
	mh.segments=contourenvelope(mh,flags);

	%segments need to be ordered in line: 
	mh.segments=alignsegments(mh.segments);

	%x,y for segments: 
	[xsegs,ysegs]=ll2xy(mh.lat(mh.segments(:,1)),mh.long(mh.segments(:,1)),hem);

	%create contour out of these segments:
	meshtodomain(mh,[temproot '/PatchEnveloppe.exp'],'latlong','on');
	expll2xy([temproot '/PatchEnveloppe.exp'],hem);

	%now, create domain outine from broad enveloppe and initial mesh 
	env=expread([temproot '/PatchEnveloppe.exp']); 
	dom=expread([temproot '/Patch.exp']);
	
	%close the contours:
	env(1).x=[env(1).x;env(1).x(1)];
	env(1).y=[env(1).y;env(1).y(1)];
	dom(1).x=[dom(1).x;dom(1).x(1)];
	dom(1).y=[dom(1).y;dom(1).y(1)];

	%flip inner hole: 
	dom(1).x=flipud(dom(1).x);
	dom(1).y=flipud(dom(1).y);

	domain(1)=env; 
	domain(2)=dom;
	expwrite(domain,[temproot '/PatchBand.exp']);

	%mesh: 
	mdb=bamg(model(),'domain',[temproot '/PatchBand.exp'],'MaxCornerAngle',1e-15,'gradation',10000); 
	mhb=mdb.mesh; clear mdb;

	%double check: 
	if length(mhb.segments) ~= (length(dom(1).x)+length(env(1).x)-2),
		%error('band mesh not consistent');
	end

	%augment patch with band
	[mhb.lat,mhb.long]=xy2ll(mhb.x,mhb.y,hem);
	mh2db=augment2dmesh(mh2d,mhb);

	%merge inner band and earth: 
	mh=mesh3dsurfaceplug2d(mh,mh2db,flags,mh.segments,xsegs,ysegs);

	%erase temporary directory: 
	system(['rm -rf ' temproot]);

end
