%MISCELLANEOUS class definition
%
%   Usage:
%      miscellaneous=miscellaneous();

classdef miscellaneous
	properties (SetAccess=public) 
		notes = '';
		name  = '';
		dummy = struct();
	end
	methods
        function createxml(self,fid) % {{{
            fprintf(fid, '<!-- miscellaneous -->\n');            
                    
            % miscellaneous solution parameters
            fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="miscellaneous parameters">','<section name="miscellaneous" />');                    
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="notes" type="',class(self.notes),'" default="',convert2str(self.notes),'">','     <section name="miscellaneous" />','     <help> notes in a cell of strings </help>','  </parameter>');
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="name" type="',class(self.name),'" default="',convert2str(self.name),'">','     <section name="miscellaneous" />','     <help> model name </help>','  </parameter>');
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="dummy" type="',class(self.dummy),'" default="',convert2str(self.dummy),'">','     <section name="miscellaneous" />','     <help> empty field to store some data </help>','  </parameter>');
            fprintf(fid,'%s\n%s\n','</frame>');    
        
        end % }}}        
		function self = miscellaneous(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','miscellaneous.name','empty',1);

		end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   miscellaneous parameters:'));

			fielddisplay(self,'notes','notes in a cell of strings');
			fielddisplay(self,'name','model name');
			fielddisplay(self,'dummy','empty field to store some data');

		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','name','format','String');
		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
		
			writejsstring(fid,[modelname '.miscellaneous.notes'],self.notes);
			writejsstring(fid,[modelname '.miscellaneous.name'],self.name);
			if strcmpi(class(self.dummy),'double'),
				writejs1Darray(fid,[modelname '.miscellaneous.dummy'],self.dummy);
			end

		end % }}}
	end
end
