function slider(initialvalue,functionvalue,slidername){
	
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var  options = new pairoptions(args.slice(3,args.length));

	//Recover option values:
	min=options.getfieldvalue('min',.6*initialvalue);
	max=options.getfieldvalue('max',1.4*initialvalue);
	sliderheight=options.getfieldvalue('sliderheight',32);
	message=options.getfieldvalue('message','');
	startmessage=options.getfieldvalue('startmessage',message);
	middlemessage=options.getfieldvalue('middlemessage',message);
	endmessage=options.getfieldvalue('endmessage',message);
	color=options.getfieldvalue('color','#bbbbbb');
	precision=options.getfieldvalue('precision',3);
	step=options.getfieldvalue('step',1);

	$('<div id="slider_'+slidername+'"></div>').appendTo('#sliders');
	$('<div id="info_'+slidername+'">'+startmessage[0]+initialvalue.toString()+startmessage[1]+'</div>').appendTo('#sliders');
	var info=$('#info_'+slidername);
	$('#slider_'+slidername).slider({
		range:'min',
		value:initialvalue,
		min:min,
		max:max,
		step:step,
		slide:function(event,ui){
			moveSlide(event,ui,info,middlemessage);
		},
		stop:function(event,ui){
			stopSlide(event,ui,info,functionvalue,middlemessage,endmessage);
		},
	});
	$('.ui-slider').css({
		width:'90%',
		height:sliderheight,
		background:color,
		margin:'8px 12px'
	});
	$('.ui-slider-handle').css({
		background:color,
		height:sliderheight*1.3
	});
	$('.ui-slider-range').css({
		background:color
	});

}

function moveSlide(event,ui,info,middlemessage){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
}

function stopSlide(event,ui,info,functionvalue,middlemessage,endmessage){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
	functionvalue(val);
	info.text(endmessage[0]+val.toPrecision(precision).toString()+endmessage[1]);
}
