%CALVINGPI class definition
%
%   Usage:
%      calvingpi=calvingpi();

classdef calvingpi
	properties (SetAccess=public) 
		stabilization = 0;
		spclevelset   = NaN;
		coeff         = NaN;
		meltingrate   = NaN;
	end
	methods
		function self = calvingpi(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calvingpi');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							self.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
			self.spclevelset=project3d(md,'vector',self.spclevelset,'type','node');
			self.coeff=project3d(md,'vector',self.coeff,'type','node');
			self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node');
		end % }}}
		function self = setdefaultparameters(self) % {{{

			%stabilization = 2 by default
			self.stabilization = 2;

			%Proportionality coefficient in Pi model
			self.coeff=2e13;
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.iscalving==0), return; end

			md = checkfield(md,'fieldname','calving.spclevelset','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','calving.stabilization','values',[0 1 2]);
			md = checkfield(md,'fieldname','calving.coeff','>',0,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','calving.meltingrate','NaN',1,'Inf',1,'size',[md.mesh.numberofvertices 1],'>=',0);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Calving Pi parameters:'));
			fielddisplay(self,'stabilization','0: no, 1: artificial_diffusivity, 2: streamline upwinding');
			fielddisplay(self,'spclevelset','Levelset constraints (NaN means no constraint)');
			fielddisplay(self,'coeff','proportionality coefficient in Pi model');
			fielddisplay(self,'meltingrate','melting rate at given location [m/a]');

		end % }}}
		function marshall(self,md,fid) % {{{
			yts=365.0*24.0*3600.0;
			WriteData(fid,'enum',CalvingLawEnum(),'data',CalvingPiEnum(),'format','Integer');
			WriteData(fid,'enum',LevelsetStabilizationEnum(),'data',self.stabilization,'format','Integer');
			WriteData(fid,'enum',SpcLevelsetEnum(),'data',self.spclevelset,'format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'enum',CalvingpiCoeffEnum(),'data',self.coeff,'format','DoubleMat','mattype',1);
			WriteData(fid,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'scale',1./yts);
		end % }}}
	end
end
