//GEOMETRY class definition
//
//   Usage:
//      geometry=geometry();

function geometry(){
	//methods 
		this.setdefaultparameters = function (){ //{{{
		}// }}}
		this.disp = function () { //{{{
			console.log(sprintf("   Geometry parameters:"));

			fielddisplay(this,'surface','ice upper surface elevation [m]');
			fielddisplay(this,'thickness','ice thickness [m]');
			fielddisplay(this,'base','ice base elevation [m]');
			fielddisplay(this,'bed','bed elevation [m]');
		} //}}}
		this.classname = function () { //{{{
			return 'geometry';
		} //}}}
		this.checkconsistency = function(md,solution,analyses) { //{{{

			if ((solution==TransientSolutionEnum() & md.trans.isgia) | (solution==GiaSolutionEnum())){
				checkfield(md,'fieldname','geometry.thickness','timeseries',1,'NaN',1,'Inf',1,'>=',0);
			}
			else{
				checkfield(md,'fieldname','geometry.surface'  ,'NaN',1,'Inf',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','geometry.base'      ,'NaN',1,'Inf',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','geometry.thickness','NaN',1,'Inf',1,'size',[md.mesh.numberofvertices, 1],'>',0);
				for(var i=0;i<md.mesh.numberofvertices;i++){
					if (Math.abs(md.geometry.thickness.thickness-md.geometry.surface+md.geometry.base)>Math.pow(10,9)){
						md = checkmessage(md,'equality thickness=surface-base violated');
						break;
					}
				}
				if (solution==TransientSolutionEnum() & md.trans.isgroundingline){
					checkfield(md,'fieldname','geometry.bed','NaN',1,'Inf',1,'size',[md.mesh.numberofvertices, 1]);
				}
			}
		} // }}}
		this.marshall=function(md,fid) { //{{{
			WriteData(fid,'data',this.surface,'format','DoubleMat','mattype',1,'enum',SurfaceEnum());
			WriteData(fid,'data',this.thickness,'format','DoubleMat','mattype',1,'enum',ThicknessEnum(),'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'data',this.base,'format','DoubleMat','mattype',1,'enum',BaseEnum());
			WriteData(fid,'data',this.bed,'format','DoubleMat','mattype',1,'enum',BedEnum());
			WriteData(fid,'object',this,'fieldname','hydrostatic_ratio','format','DoubleMat','mattype',1);
		}//}}}
		this.fix=function() { //{{{
			this.hydrostatic_ratio=NullFix(this.hydrostatic_ratio,NaN);
		}//}}}
	//properties 
	// {{{
		this.surface           = NaN;
		this.thickness         = NaN;
		this.base              = NaN;
		this.bed               = NaN;
		this.hydrostatic_ratio = NaN;
		this.setdefaultparameters();
		//}}}
}
