//CALVING class definition
//
//   Usage:
//      calving=new calving();

function calving (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//stabilization = 2 by default
		this.stabilization = 2;
	
	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   Calving parameters:'));
		fielddisplay(this,'stabilization','0: no, 1: artificial_diffusivity, 2: streamline upwinding');
		fielddisplay(this,'spclevelset','Levelset constraints (NaN means no constraint)');
		fielddisplay(this,'calvingrate','calving rate at given location [m/a]');
		fielddisplay(this,'meltingrate','melting rate at given location [m/a]');

	}// }}}
	this.classname= function(){// {{{
		return "calving";
	}// }}}
	this.checkconsistency = function(md,solution,analyses) { // {{{
		//Early return
		if (solution!=TransientSolutionEnum() | md.trans.iscalving==0) return;

		checkfield(md,'fieldname','calving.spclevelset','timeseries',1);
		checkfield(md,'fieldname','calving.stabilization','values',[0,1,2]);
		checkfield(md,'fieldname','calving.calvingrate(1:md.mesh.numberofvertices,:)','>=',0,'timeseries',1,'NaN',1,'Inf',1);
		checkfield(md,'fieldname','calving.meltingrate(1:md.mesh.numberofvertices,:)','>=',0,'timeseries',1,'NaN',1,'Inf',1);
	} //}}}
		this.marshall=function(md,fid) { //{{{
			var yts=365.0*24.0*3600.0;
			WriteData(fid,'enum',CalvingLawEnum(),'data',DefaultCalvingEnum(),'format','Integer');
			WriteData(fid,'enum',LevelsetStabilizationEnum(),'data',this.stabilization,'format','Integer');
			WriteData(fid,'enum',SpcLevelsetEnum(),'data',this.spclevelset,'format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',this,'fieldname','calvingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'scale',1./yts);
			WriteData(fid,'object',this,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'scale',1./yts);
		}//}}}
		this.fix=function() { //{{{
			this.spclevelset=NullFix(this.spclevelset,NaN);
			this.calvingrate=NullFix(this.calvingrate,NaN);
			this.meltingrate=NullFix(this.meltingrate,NaN);
		}//}}}
	//properties 
	// {{{

	this.stabilization = 0;
	this.spclevelset   = NaN;
	this.calvingrate   = NaN;
	this.meltingrate   = NaN;

	this.setdefaultparameters();
	//}}}
}
