%FRICTIONWEERTMAN class definition
%
%   Usage:
%      frictionweertman=frictionweertman();

classdef frictionweertman
	properties (SetAccess=public) 
		C = NaN;
		m = NaN;
	end
	methods
		function createxml(self,fid) % {{{
			fprintf(fid, '\n\n');
			fprintf(fid, '%s\n', '<!-- Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p -->');
			fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p">','<section name="frictionweertman" />');   
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="coefficient" type="',   	class(self.coefficient),'" default="',     	convert2str(self.coefficient),'">',              '     <section name="frictionweertman" />','     <help> frictionweertman coefficient [SI] </help>','</parameter>');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="p" type="',               class(self.p),'" default="',                 convert2str(self.p),'">',   '     <section name="frictionweertman" />','     <help> p exponent </help>','</parameter>');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n',        '<parameter key ="q" type="',               class(self.q),'" default="',                 convert2str(self.q),'">',            '     <section name="frictionweertman" />','     <help> q exponent </help>','</parameter>');
			fprintf(fid,'%s\n%s\n','</frame>');
		end % }}}
		function self = frictionweertman(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
			md.friction.C=project3d(md,'vector',md.friction.C,'type','node','layer',1);
			md.friction.m=project3d(md,'vector',md.friction.m,'type','element');
		end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end
			md = checkfield(md,'fieldname','friction.C','timeseries',1,'NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','friction.m','NaN',1,'Inf',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(self) % {{{
			disp('Weertman sliding law parameters:');
			disp('   Weertman''s sliding law reads:');
			disp('      v_b = C * Sigma_b^m');
			disp('   In ISSM, this law is rewritten as:');
			disp('      Sigma_b = C^(-1/m) * |u_b|^(1/m-1)  u_b');
			disp(' ');
			fielddisplay(self,'C','friction coefficient [SI]');
			fielddisplay(self,'m','m exponent');
		end % }}}
		function marshall(self,md,fid) % {{{
			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',FrictionLawEnum,'data',2,'format','Integer');
			WriteData(fid,'class','friction','object',self,'fieldname','C','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
			WriteData(fid,'class','friction','object',self,'fieldname','m','format','DoubleMat','mattype',2);
			

		end % }}}
	end
end
