%DEBUG class definition
%
%   Usage:
%      debug=debug();

classdef debug
	properties (SetAccess=public) 
		valgrind = false;
		gprof    = false;
		profiling = false;
	end
	methods
        function createxml(self,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- Debug -->');
            
            %valgrind drop-down (0 or 1)
			fprintf(fid,'%s\n%s\n%s%s%s\n%s\n%s\n',    '<parameter key ="valgrind" type="alternative" optional="false">','     <section name="debug" />','     <help> use Valgrind to debug (0 or 1) </help>');
            fprintf(fid,'%s\n','       <option value="0" type="string" default="true"> </option>');
            fprintf(fid,'%s\n%s\n','       <option value="1" type="string" default="false"> </option>','</parameter>');
          
            fprintf(fid,'%s%s%s\n%s\n%s%s%s\n%s\n%s\n',    '<parameter key ="gprof" type="',              class(self.gprof),'" optional="false">',              '     <section name="debug" />','        <option value="',convert2str(self.gprof),'" type="string" default="true"></option>','     <help> use gnu-profiler to find out where the time is spent </help>','</parameter>');
            fprintf(fid,'%s%s%s\n%s\n%s%s%s\n%s\n',    '<parameter key ="profiling" type="',              class(self.profiling),'" optional="false">',              '     <section name="debug" />','        <option value="',convert2str(self.profiling),'" type="string" default="true"></option>','     <help> enables profiling (memory, flops, time) </help>','</parameter>');
        end % }}}
		function self = debug(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
				end
			end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   debug parameters:'));

			fielddisplay(self,'valgrind','use Valgrind to debug (0 or 1)');
			fielddisplay(self,'gprof','use gnu-profiler to find out where the time is spent');
			fielddisplay(self,'profiling','enables profiling (memory, flops, time)');

		end % }}}
		function marshall(self,md,fid) % {{{
			WriteData(fid,'object',self,'fieldname','profiling','format','Boolean');
		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
		
			writejsdouble(fid,[modelname '.debug.valgrind'],self.valgrind);
			writejsdouble(fid,[modelname '.debug.gprof'],self.gprof);
			writejsdouble(fid,[modelname '.debug.profiling'],self.profiling);

		end % }}}
	end
end
