function plot_unit(md,data,options,canvas,gl,node) {
	//PLOT_UNIT - unit plot, display data
	//
	//   Usage:
	//      plot_unit(md,data,options,canvas,gl);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var datamin,datamax;
	var scale;

	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	
	var dataresults = processdata(md,data,options);
	var data2 = dataresults[0]; 
	var datatype = dataresults[1];
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
	var caxis= options.getfieldvalue('caxis',[ArrayMin(data),ArrayMax(data)]);
	datamin = caxis[0];
	datamax = caxis[1];

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale];
	node["rotation"] = options.getfieldvalue('view',[0,0,0]);
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["alpha"] = options.getfieldvalue('alpha',1.0);
	node["overlay"] = options.getfieldvalue('overlay','off') == 'on';
	node["drawOrder"] = 0;
		
	//some defaults:
	texcoords.itemSize = 2;

	switch(datatype){

		//element plot {{{
		case 1:

			pos=ArrayFindNot(data,NaN); //needed for element on water
			if (elements[0].length==6){ //prisms

				/*A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); D=elements(pos,4); E=elements(pos,5); F=elements(pos,6);
				  patch( 'Faces', [A B C],  'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [D E F],  'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [A B E D],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [B E F C],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [C A D F],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  */
			}
			else if (elements[0].length==4){ //tetras
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4);
				  patch( 'Faces',[A B C],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[A B D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[B C D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[C A D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);*/
			}
			else{ //2D triangular elements
				
				/*A=elements(pos,1); B=elements(pos,2); C=elements(pos,3);
				  patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);*/
			}
			break;
		//}}}
		//node plot {{{
		case 2:

			if (elements[0].length==6){ //prisms
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
				  patch( 'Faces', [A B C],  'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [D E F],  'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [A B E D],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [B E F C],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [C A D F],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);*/
			}
			else if (elements[0].length==4){//tetras
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4);
				  patch( 'Faces',[A B C],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[A B D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[B C D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[C A D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);*/
			}
			else{ //triangular elements
			
				vertices.itemSize = 3;
				var cmap=options.getfieldvalue('cmap','jet');	
				for(var i = 0; i < x.length; i++){
					vertices[vertices.length] = x[i];
					vertices[vertices.length] = y[i];
					vertices[vertices.length] = z[i];

					texcoords[texcoords.length] = 0.5;
					texcoords[texcoords.length] = (data[i] - datamin) / (datamax - datamin);
				}
				
				//linearize the elements array: 
				indices = indices.concat.apply(indices, elements); 
				indices.itemSize = 1;
				for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.

			}
			break;
		//}}}
		//quiver plot {{{
		case 3:

			if (is2d){
				//plot_quiver(x,y,data(:,1),data(:,2),options);
			}
			else{
				//plot_quiver3(x,y,z,data(:,1),data(:,2),data(:,3),options);
			}

		//}}}
		default:
			throw Error(sprintf("%s%i%s\n",'case ',datatype,' not supported'));
	}
	
	/*Initalize buffers: */
	node["arrays"] = [vertices, texcoords, indices];
	node["buffers"] = initBuffers(gl,node["arrays"]);
}
