function plot_overlay(md,data,options,canvas,gl,node){
	//PLOT_OVERLAY - Function for plotting a georeferenced image.  
	//This function is called from within the plotmodel code.
	//
	//   Usage:
	//      plot_overlay(md,data,options,canvas,gl,node);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	
	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	//}}}

	//Compute coordinates and data range:
	var xlim = options.getfieldvalue('xlim',[ArrayMin(x),ArrayMax(x)]);
	var ylim = options.getfieldvalue('ylim',[ArrayMin(y),ArrayMax(y)]);
	var zlim = options.getfieldvalue('zlim',[ArrayMin(z),ArrayMax(z)]);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
	
	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale];
	node["rotation"] = options.getfieldvalue('view',[0,0,0]);
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["texture"] = initTexture(gl,options.getfieldvalue('image','images/penguin.png'));
	node["alpha"] = options.getfieldvalue('alpha',1.0);
	node["overlay"] = true;
				
	//some defaults:
	texcoords.itemSize = 2;
	vertices.itemSize = 3;
	
	var xrange = xmax - xmin;
	var yrange = ymax - ymin;

	//redefine overlay as square plane
	//x = [xmin, xmax, xmin, xmax];
	//y = [ymin, ymin, ymax, ymax];
	//z = [zmin, zmin, zmin, zmin];
	//elements = [[1,2,3],[2,4,3]];
	
	//generate mesh:
	for(var i = 0; i < x.length; i++){
		vertices[vertices.length] = x[i];
		vertices[vertices.length] = y[i];
		vertices[vertices.length] = z[i];

		texcoords[texcoords.length] = (x[i] - xmin) / xrange;
		texcoords[texcoords.length] = (y[i] - ymin) / yrange;
	}
	
	//linearize the elements array: 
	indices = indices.concat.apply(indices, elements); 
	indices.itemSize = 1;
	for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.
	
	/*Initalize buffers: */
	node["buffers"] = initBuffers(gl,[vertices, texcoords, indices]);
}
