function plot_mesh(md,options,canvas,gl,node) {
	//   Usage:
	//      plot_mesh(md,options,canvas,gl);
	//
	//   See also: PLOTMODEL

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var colors = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var scale;
	//Process data and model
	var x = md.mesh.x;
	var y = md.mesh.y;
	var z = [0.0];
	var elements = md.mesh.elements;
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "colored";
	node["scale"] = [scale, scale, scale];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["drawMode"] = gl.LINES;
				
	//some defaults:
	colors.itemSize = 4;

	//retrieve some options
	var linewidth=options.getfieldvalue('linewidth',1);
	var edgecolor=options.getfieldvalue('edgecolor','black');

	// populate arrays 
	//node plot {{{
	if (elements[0].length==6){ //prisms
		/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
		  patch( 'Faces', [A B C],  'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces', [D E F],  'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces', [A B E D],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces', [B E F C],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces', [C A D F],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  */
	}
	else if (elements[0].length==4){ //tetras
		/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4);
		  patch( 'Faces',[A B C],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces',[A B D],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces',[B C D],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  patch( 'Faces',[C A D],'Vertices', [x y z],'FaceVertexCData',zeros(size(x)),'FaceColor','none','EdgeColor',edgecolor,'linewidth',linewidth);
		  */
	}
	else{ //2D triangular elements
		vertices.itemSize = 3;
		for(var i = 0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			//vertices[vertices.length] = z[i];
			vertices[vertices.length] = 0;

			//handle mesh/qinterest size mismatch
			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//linearize the elements array: 

		for(var i = 0; i < elements.length; i++){
			//convert tris to line edges; generates more edges than necessary, should optimize using node connectivity
			//matlab indices from 1, so decrement indices.
			indices[indices.length] = elements[i][0] - 1;
			indices[indices.length] = elements[i][1] - 1;
			indices[indices.length] = elements[i][1] - 1;
			indices[indices.length] = elements[i][2] - 1;
			indices[indices.length] = elements[i][2] - 1;
			indices[indices.length] = elements[i][0] - 1;
		}
		indices.itemSize = 1;
	}
	//}}}

	/*//apply options
	options=addfielddefault(options,'title','Mesh');
	options=addfielddefault(options,'colorbar',0);
	applyoptions(md,[],options);
	*/

	/*Initalize buffers: */
	node["arrays"] = [vertices, colors, indices];
	node["buffers"] = initBuffers(gl, node["arrays"]);
}
