//INITIALIZATION class definition
//
//   Usage:
//      initialization=new initialization();

function initialization (){
	//methods
	this.setdefaultparameters = function(){// {{{
	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   initial field values:'));

		fielddisplay(this,'vx','x component of velocity [m/yr]');
		fielddisplay(this,'vy','y component of velocity [m/yr]');
		fielddisplay(this,'vz','z component of velocity [m/yr]');
		fielddisplay(this,'vel','velocity norm [m/yr]');
		fielddisplay(this,'pressure','pressure field [Pa]');
		fielddisplay(this,'temperature','temperature [K]');
		fielddisplay(this,'waterfraction','fraction of water in the ice');
		fielddisplay(this,'sediment_head','sediment water head of subglacial system [m]');
		fielddisplay(this,'epl_head','epl water head of subglacial system [m]');
		fielddisplay(this,'epl_thickness','epl layer thickness [m]');
		fielddisplay(this,'watercolumn','thickness of subglacial water [m]');

	}// }}}
		this.checkconsistency = function(md,solution,analyses) { //{{{
			if(ArrayAnyEqual(ArrayIsMember(StressbalanceAnalysisEnum(),analyses),1)){
				if (!(isNaN(md.initialization.vx) | isNaN(md.initialization.vy))){
					checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices, 1]);
					checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				}
			}
			if(ArrayAnyEqual(ArrayIsMember(MasstransportAnalysisEnum(),analyses),1)){
				checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices, 1]);
			}
			if(ArrayAnyEqual(ArrayIsMember(BalancethicknessSolutionEnum(),analyses),1) & (solution==BalancethicknessSolutionEnum())){
				checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				//Triangle with zero velocity
				for(var i=0;i<md.mesh.numberofelements;i++){
					var sum=0;
					for(var j=0;j<md.mesh.elements[0].length;j++){
						if  ((md.initialization.vx[md.mesh.elements[i][j]-1]==0) & (md.initialization.vy[md.mesh.elements[i][j]-1]==0)) sum+=1;
					}
					if (sum==md.mesh.elements[0].length){
						md.checkmessage('at least one triangle has all its vertices with a zero velocity');
					}
				}
			}
			if(ArrayAnyEqual(ArrayIsMember(ThermalAnalysisEnum(),analyses),1)){
				checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				if (md.mesh.dimension() == 3){
					checkfield(md,'fieldname','initialization.vz','NaN',1,'size',[md.mesh.numberofvertices ,1]);
				}
				checkfield(md,'fieldname','initialization.pressure','NaN',1,'size',[md.mesh.numberofvertices ,1]);
				checkfield(md,'fieldname','initialization.temperature','NaN',1,'size',[md.mesh.numberofvertices ,1]);
			}
			if( ArrayAnyEqual(ArrayIsMember(EnthalpyAnalysisEnum(),analyses),1) & md.thermal.isenthalpy){
				checkfield(md,'fieldname','initialization.waterfraction','>=',0,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','initialization.watercolumn'  ,'>=',0,'size',[md.mesh.numberofvertices, 1]);
			}
			if(ArrayAnyEqual(ArrayIsMember(HydrologyShreveAnalysisEnum(),analyses),1)){
				if (md.hydrology.type() == 'hydrologyshreve'){
					checkfield(md,'fieldname','initialization.watercolumn','NaN',1,'size',[md.mesh.numberofvertices ,1]);
				}
			}
			if(ArrayAnyEqual(ArrayIsMember(HydrologyDCInefficientAnalysisEnum(),analyses),1)){
				if (md.hydrology.type() == 'hydrologydc'){
					checkfield(md,'fieldname','initialization.sediment_head','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				}
			}
			if(ArrayAnyEqual(ArrayIsMember(HydrologyDCEfficientAnalysisEnum(),analyses),1)){
				if (md.hydrology.type() == 'hydrologydc'){
					if (md.hydrology.isefficientlayer==1){
						checkfield(md,'fieldname','initialization.epl_head','NaN',1,'size',[md.mesh.numberofvertices ,1]);
						checkfield(md,'fieldname','initialization.epl_thickness','NaN',1,'size',[md.mesh.numberofvertices ,1]);
					}
				}
			}
		} //}}}
		this.marshall=function(md,fid) { //{{{

			var yts=365.0*24.0*3600.0;

			WriteData(fid,'data',this.vx.slice(),'format','DoubleMat','mattype',1,'enum',VxEnum(),'scale',1./yts);
			WriteData(fid,'data',this.vy.slice(),'format','DoubleMat','mattype',1,'enum',VyEnum(),'scale',1./yts);
			WriteData(fid,'data',this.vz.slice(),'format','DoubleMat','mattype',1,'enum',VzEnum(),'scale',1./yts);
			WriteData(fid,'data',this.pressure.slice(),'format','DoubleMat','mattype',1,'enum',PressureEnum());
			WriteData(fid,'data',this.temperature.slice(),'format','DoubleMat','mattype',1,'enum',TemperatureEnum());
			WriteData(fid,'data',this.waterfraction,'format','DoubleMat','mattype',1,'enum',WaterfractionEnum());
			WriteData(fid,'data',this.sediment_head,'format','DoubleMat','mattype',1,'enum',SedimentHeadEnum());
			WriteData(fid,'data',this.epl_head,'format','DoubleMat','mattype',1,'enum',EplHeadEnum());
			WriteData(fid,'data',this.epl_thickness,'format','DoubleMat','mattype',1,'enum',HydrologydcEplThicknessEnum());
			WriteData(fid,'data',this.watercolumn,'format','DoubleMat','mattype',1,'enum',WatercolumnEnum());

			if (md.thermal.isenthalpy){
				tpmp=NewArrayFill(md.mesh.numberofvertices,0);
				for (var i=0;i<md.mesh.numberofvertices;i++) tpmp[i]= md.materials.meltingpoint - md.materials.beta*md.initialization.pressure[i];
				enthalpy=NewArrayFill(md.mesh.numberofvertices,0); 
				for (var i=0;i<md.mesh.numberofvertices;i++)enthalpy[i] = md.materials.heatcapacity*(md.initialization.temperature[i]-md.constants.referencetemperature);
				
				for (var i=0;i<md.mesh.numberofvertices;i++)if(md.initialization.temperature[i]>=tpmp[i]){
					enthalpy[i] = md.materials.heatcapacity*(tpmp[i] - md.constants.referencetemperature) + md.materials.latentheat*md.initialization.waterfraction[i];
				}
				WriteData(fid,'data',enthalpy,'format','DoubleMat','mattype',1,'enum',EnthalpyEnum());
			}
		}//}}}
		this.fix=function(md) { //{{{
			this.vx=FloatFix(this.vx,md.mesh.numberofvertices); 
			this.vy=FloatFix(this.vx,md.mesh.numberofvertices); 
			this.vy=FloatFix(this.vx,md.mesh.numberofvertices); 
			this.waterfraction=NullFix(this.waterfraction,NaN);
			this.sediment_head=NullFix(this.sediment_head,NaN);
			this.epl_head=NullFix(this.epl_head,NaN);
			this.epl_thickness=NullFix(this.epl_thickness,NaN);
			this.watercolumn=NullFix(this.watercolumn,NaN);
		}//}}}
	//properties 
	// {{{
	this.vx            = NaN;
	this.vy            = NaN;
	this.vz            = NaN;
	this.vel           = NaN;
	this.pressure      = NaN;
	this.temperature   = NaN;
	this.waterfraction = NaN;
	this.sediment_head = NaN;
	this.epl_head      = NaN;
	this.epl_thickness = NaN;
	this.watercolumn   = NaN;
	this.setdefaultparameters();

	//}}}
}
