//TRANS class definition
//
//   Usage:
//      trans =new trans();

function trans (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//full analysis: Stressbalance, Masstransport and Thermal but no groundingline migration for now
		this.issmb           = 1;
		this.ismasstransport = 1;
		this.isstressbalance = 1;
		this.isthermal       = 1;
		this.isgroundingline = 0;
		this.isgia           = 0;
		this.isdamageevolution = 0;
		this.islevelset      = 0;
		this.iscalving       = 0;
		this.ishydrology     = 0;

		//default output
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   transient solution parameters:'));

		fielddisplay(this,'issmb','indicates whether a surface mass balance solution is used in the transient');
		fielddisplay(this,'ismasstransport','indicates whether a masstransport solution is used in the transient');
		fielddisplay(this,'isstressbalance','indicates whether a stressbalance solution is used in the transient');
		fielddisplay(this,'isthermal','indicates whether a thermal solution is used in the transient');
		fielddisplay(this,'isgroundingline','indicates whether a groundingline migration is used in the transient');
		fielddisplay(this,'isgia','indicates whether a postglacial rebound model is used in the transient');
		fielddisplay(this,'isdamageevolution','indicates whether damage evolution is used in the transient');
		fielddisplay(this,'islevelset','LEVEL SET DESCRIPTION...');
		fielddisplay(this,'iscalving','indicates whether calving is used in the transient');
		fielddisplay(this,'ishydrology','indicates whether an hydrology model is used');
		fielddisplay(this,'requested_outputs','list of additional outputs requested');


	}// }}}
	this.classname= function(){// {{{
		return "transient";
	}// }}}
		this.checkconsistency = function(md,solution,analyses) { // {{{

			//Early return
			if (solution!=TransientSolutionEnum()) return;

			checkfield(md,'fieldname','transient.issmb','numel',[1],'values',[0 ,1]);
			checkfield(md,'fieldname','transient.ismasstransport','numel',[1],'values',[0 ,1]);
			checkfield(md,'fieldname','transient.isstressbalance','numel',[1],'values',[0 ,1]);
			checkfield(md,'fieldname','transient.isthermal','numel',[1],'values',[0 ,1]);
			checkfield(md,'fieldname','transient.isgroundingline','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','transient.isgia','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','transient.isdamageevolution','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','transient.islevelset','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','transient.iscalving','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','transient.ishydrology','numel',[1],'values',[0 ,1]);
			checkfield(md,'fieldname','transient.requested_outputs','stringrow',1);
		} // }}}
		this.marshall=function(md,fid) { //{{{
			WriteData(fid,'object',this,'fieldname','issmb','format','Boolean');
			WriteData(fid,'object',this,'fieldname','ismasstransport','format','Boolean');
			WriteData(fid,'object',this,'fieldname','isstressbalance','format','Boolean');
			WriteData(fid,'object',this,'fieldname','isthermal','format','Boolean');
			WriteData(fid,'object',this,'fieldname','isgroundingline','format','Boolean');
			WriteData(fid,'object',this,'fieldname','isgia','format','Boolean');
			WriteData(fid,'object',this,'fieldname','isdamageevolution','format','Boolean');
			WriteData(fid,'object',this,'fieldname','ishydrology','format','Boolean');
			WriteData(fid,'object',this,'fieldname','islevelset','format','Boolean');
			WriteData(fid,'object',this,'fieldname','iscalving','format','Boolean');

			//process requested outputs
			outputs = this.requested_outputs;
			for (var i=0;i<outputs.length;i++){
				if (outputs[i] == 'default') {
					outputs.splice(i,1);
					newoutputs=this.defaultoutputs(md);
					for (var j=0;j<newoutputs.length;j++) outputs.push(newoutputs[j]);
				}
			}			
			WriteData(fid,'data',outputs,'enum',TransientRequestedOutputsEnum(),'format','StringArray');
		}//}}}
		this.defaultoutputs = function(md) { //{{{
			if(this.issmb)return ['SmbMassBalance'];
			else return [];
		}//}}}
	//properties 
	// {{{

	this.issmb             = 0;
	this.ismasstransport   = 0;
	this.isstressbalance   = 0;
	this.isthermal         = 0;
	this.isgroundingline   = 0;
	this.isgia             = 0;
	this.isdamageevolution = 0;
	this.islevelset        = 0;
	this.iscalving         = 0;
	this.ishydrology       = 0;
	this.requested_outputs = [];

	this.setdefaultparameters();
	//}}}
}
