function loadresultsfrombuffer(md,buffer,buffersize){
//LOADRESULTSFROMBUFFER - load results of solution sequence from memory buffer 
//
//   Usage:
//      loadresultsfrombuffer(md,buffer,buffersize);

	//check number of inputs/outputs
	if (arguments.length!=3) throw Error('loadresultsfrombuffer error message: wrong usage!');

	if (!md.qmu.isdakota){

		//initialize md.results if not a structure yet
		if (MapIsEmpty(md.results)) md.results={};

		//load results onto model
		var array=parseresultsfrombuffer(buffer,buffersize);
		if (array.length==0) throw Error('No result found in binary buffer. Check for solution crash.');


		md.results[array[0]['SolutionType']] = array;
		
		//recover solution_type from results
		md.private.solution=array['SolutionType'];
	}
	else throw Error('loadresultsfrombuffer error message: qmu results not supported yet!');
}
