function applyoptions(md,data,options){
	//APPLYOPTIONS - apply the options to current plot
	//
	//   Usage:
	//      applyoptions(md,data,options)
	//
	//   See also: PLOTMODEL, PARSE_OPTIONS
	/* //{{{
	//fontsize
	fontsize=options.getfieldvalue('fontsize',14);

	//fontweight
	fontweight=options.getfieldvalue('fontweight','normal');

	//title
	if exist(options,'title')
		titlevalue=options.getfieldvalue('title');
		if iscell(titlevalue),
			title(titlevalue,'FontSize',fontsize,'FontWeight',fontweight);
		else
			if ~isnan(titlevalue),
				title(titlevalue,'FontSize',fontsize,'FontWeight',fontweight);
			end
		end
	end

	//xlabel, ylabel and zlabel
	if exist(options,'xlabel');
		xlabel(options.getfieldvalue('xlabel'),'FontSize',fontsize,'FontWeight',fontweight);
	end
	if exist(options,'ylabel');
		ylabel(options.getfieldvalue('ylabel'),'FontSize',fontsize,'FontWeight',fontweight);
	end
	if exist(options,'zlabel');
		zlabel(options.getfieldvalue('zlabel'),'FontSize',fontsize,'FontWeight',fontweight);
	end

	//xticks, yticks and zticks
	if exist(options,'xtick'), set(gca,'XTick',options.getfieldvalue('xtick')); end
	if exist(options,'ytick'), set(gca,'YTick',options.getfieldvalue('ytick')); end
	if exist(options,'ztick'), set(gca,'ZTick',options.getfieldvalue('ztick')); end

	//view 
	if dimension(md.mesh)==3 & ~exist(options,'layer'),
		view(options.getfieldvalue('view',3));
	else
		view(options.getfieldvalue('view',2));
	end

	//axis
	set(gca,'FontSize',options.getfieldvalue('axisfontsize',fontsize));;
	if exist(options,'axis')
		eval(['axis ' options.getfieldvalue('axis')]);
	else
		if strcmp(domaintype(md.mesh),'3D'),
			if ~exist(options,'layer'),
				axis auto tight
			else
				axis tight equal
			end
		elseif strcmp(domaintype(md.mesh),'2Dvertical'),
			axis auto tight
		elseif strcmp(domaintype(md.mesh),'3Dsurface'),
			axis auto tight

		elseif strcmp(domaintype(md.mesh),'2Dhorizontal'),
			axis tight equal;
		else
			error('type of domain not supported');
		end
	end

	//box
	if exist(options,'box')
		eval(['box ' options.getfieldvalue('box')]);
	end

	//xlim, ylim and zlim
	if exist(options,'xlim');
		xlim(options.getfieldvalue('xlim'));
	end
	if exist(options,'ylim');
		ylim(options.getfieldvalue('ylim'));
	end
	if exist(options,'zlim');
		zlim(options.getfieldvalue('zlim'));
	end

	//latlon
	//Must be done here (before xlim and ylim??) so that it uses the same xlim and ylim as plot_overlay
	//these are changed by axis that follows
	if ~strcmpi(options.getfieldvalue('latlon','off'),'off')
		latlonoverlay(md,options);
	end

	//Basinzoom
	if exist(options,'basin');
		basinzoom(options);
	end

	//ShowBasins
	if strcmpi(options.getfieldvalue('showbasins','off'),'on')
		showbasins(options);
	end
	*/ //}}}
	/* ///{{{
	//shading
	if exist(options,'shading'),
		shading(options.getfieldvalue('shading'));
	end

	//grid
	if exist(options,'grid'),
		if strcmpi(options.getfieldvalue('grid'),'on'),
			grid on;
		end
	end

	//colormap
	c = getcolormap(options);
	h = colormap(c);

	//wrapping
	if exist(options,'wrapping'),
		if ~exist(options,'colormap'),
			h=jet;
		end
		colormap(repmat(h,options.getfieldvalue('wrapping',1),1));
	end
	*/ //}}}
	//colorbar
	if (options.exist('colorbar')) {
		if (options.getfieldvalue('colorbar')==1) {
			if (options.exist('colorbarcornerposition')) {
				//c=colorbar(options.getfieldvalue('colorbarcornerposition'),'peer',gca);
			} else { 
			}
			var caxis = options.getfieldvalue('caxis',[Math.min.apply(null,data),Math.max.apply(null,data)]);
			var canvassize = options.getfieldvalue('canvassize',480);
			var cheight = options.getfieldvalue('colorbarheight',0.95)*canvassize;
			var cwidth = options.getfieldvalue('colorbarwidth',canvassize/20);
			var cdivisions = cheight/4;
			var color;
			var ccanvas = $('<canvas id="'+options.getfieldvalue('canvasid')+'_colorbar" width="'+cwidth+'" height="'+cheight+'"></canvas>').insertAfter('#'+options.getfieldvalue('canvasid'));
			ccanvas.css({'position':'relative','top':((canvassize-cheight)/-2).toFixed(2)+'px'});
			var ccontext = ccanvas[0].getContext('2d');
			for (var i = 0; i < cdivisions; i++) {
				var cindex= Math.floor(i / cdivisions * (colorbar.length - 1));
				color = colorbar[(colorbar.length - 1) - cindex];
				color = [Math.round(color[0] * 255), Math.round(color[1] * 255), Math.round(color[2] * 255)];	
				ccontext.fillStyle = 'rgba(' + color.toString() + ',1.0)';
				ccontext.fillRect(0, Math.floor(i * cheight / cdivisions), cwidth, Math.ceil(cheight / cdivisions));
			}
			//Set colorbar lables
			var clabels = $('<ul id="'+options.getfieldvalue('canvasid')+'_colorbar_labels"></ul>');
			clabels.css({'position':'relative','width':'auto','vertical-align':'top','height':String(cheight)+'px','list-style-type':'none','display':'inline-table','top':((canvassize-cheight)/2).toFixed(2)+'px','padding':'0px','margin':'0px '+String(cwidth/4)+'px 0px '+String(cwidth/4)+'px','font-size':String(options.getfieldvalue('colorbarfontsize',16))+'px','color':String(options.getfieldvalue('FontColor','black'))});
			clabels.insertAfter('#'+options.getfieldvalue('canvasid')+'_colorbar');
			var labels = [];
			var cdivisions = 8;
			var caxisdelta = caxis[1] - caxis[0];
			var clabelitem;

			if (options.exist('log')) {
				//logvalue=options.getfieldvalue('log');
				//set(c,'YTick',log(tick_vals)./log(logvalue));
				for (var i = cdivisions; i >= 0; i--) {
					labels[i] = (caxisdelta*i/cdivisions+caxis[0]).toPrecision(3);
				}
			} else {
				for (var i = cdivisions; i >= 0; i--) {
					labels[i] = (caxisdelta*i/cdivisions+caxis[0]).toPrecision(3);
				}
			}
			for (var i = cdivisions; i >= 0; i--) {
				var clabelitem = $('<li><div>'+labels[i]+'</div></li>')
				clabelitem.css({'display':'table-row'});
				clabelitem.find('div').css({'display':'table-cell','vertical-align':'middle'});
				clabelitem.appendTo('#'+options.getfieldvalue('canvasid')+'_colorbar_labels');
			}
			/* //{{{
			if exist(options,'wrapping')
				lim=get(c,'Ylim');
				lim=[lim(1) lim(1)+(lim(2)-lim(1))/options.getfieldvalue('wrapping')];
				set(c,'Ylim',lim);
			}
			if exist(options,'colorbarpos'),
				set(c,'Position',options.getfieldvalue('colorbarpos'));
			}
			if exist(options,'log'),
				nlab=length(get(c,'YTick'));
				logvalue=options.getfieldvalue('log');

				scaleminmax=caxis;
				Min=min(scaleminmax);
				Max=max(scaleminmax);
				set(c,'YLim',[Min Max]); // set colorbar limits
				set(c,'YTick',linspace(Min,Max,nlab));     // set tick mark locations

				labels = cell(1,nlab);
				tick_vals = linspace(Min,Max,nlab);
				tick_vals = exp(log(logvalue)*tick_vals);
				warning off MATLAB:log:logOfZero;
				for i = 1:nlab
					labels{i} = sprintf('//-3.4g',round_ice(tick_vals(i),2));
					//labels{i} = sprintf('//-.4g',round_ice(tick_vals(i),2));
				}
				warning on MATLAB:log:logOfZero;
				set(c,'YTickLabel',labels);
			} 
			if exist(options,'cbYLim'); 
				set(c,'YLim',options.getfieldvalue('cbYLim'));
			}
			if exist(options,'colorbartitle'),
				set(get(c,'title'),'FontSize',options.getfieldvalue('colorbarfontsize',fontsize),'String',options.getfieldvalue('colorbartitle'),...
					'Color',options.getfieldvalue('FontColor','k'));
			}
			if exist(options,'colorbarYLabel'),
				set(get(c,'Ylabel'),'FontSize',options.getfieldvalue('colorbarfontsize',fontsize),'String',options.getfieldvalue('colorbarYLabel'),...
					'Color',options.getfieldvalue('FontColor','k'));
			}
			if exist(options,'colorbarwidth'),
				posaxes=get(gca,'Position');
				alpha=options.getfieldvalue('colorbarwidth',1);
				position=get(c,'Position');
				dx=position(3);
				newdx=dx*alpha;
				position(1)=position(1)+(dx-newdx)/2;
				position(3)=newdx;
				set(c,'Position',position);
				set(gca,'Position',posaxes);
			}
			if exist(options,'colorbarheight'),
				posaxes=get(gca,'Position');
				alpha=options.getfieldvalue('colorbarheight',1);
				position=get(c,'Position');
				dy=position(4);
				newdy=dy*alpha;
				position(2)=position(2)+(dy-newdy)/2;
				position(4)=newdy;
				set(c,'Position',position);
				set(gca,'Position',posaxes);
			}
			if (options.exist('cbYTickLabel')) {
			}
			*/ //}}}
		}
	} else {
		//do nothing

	}
	/* //{{{
	//area
	if exist(options,'area'),
		antzoom(options.getfieldvalue('area'));
	end

	//expdisp
	if exist(options,'expdisp'),
		filename=(options.getfieldvalue('expdisp'));
		style=(options.getfieldvalue('expstyle'));
		linewidth=(options.getfieldvalue('linewidth',1));
		for i=1:length(options.getfieldvalue('expdisp')),
			filenamei=filename{i};
			stylei=style{i};
			if length(linewidth)==1,
				linewidthi=linewidth;
			else
				linewidthi=linewidth{i};
			end
			expdisp(filenamei,'linestyle',stylei,'linewidthi',linewidthi,'multiplier',options.getfieldvalue('unit',1));
		end
	end

	//text (default value is empty, not NaN...)
	if exist(options,'text');
		textstring=options.getfieldvalue('text');
		textweight=options.getfieldvalue('textweight','b');
		textsize=options.getfieldvalue('textsize');
		textcolor=options.getfieldvalue('textcolor');
		textposition=options.getfieldvalue('textposition');
		textrotation=options.getfieldvalue('textrotation');
		for i=1:length(options.getfieldvalue('text'));
			textstringi=textstring{i};
			textweighti=textweight{i};
			textsizei=textsize{i};
			textcolori=textcolor{i};
			textpositioni=textposition{i};
			textrotationi=textrotation{i};
			h=text(textpositioni(1),textpositioni(2),10,textstringi,'FontSize',textsizei,'FontWeight',textweighti,'Color',textcolori,'Rotation',textrotationi);
			set(h,'Clipping','on'); //prevent text from appearing outside of the box
		end
	end

	//north arrow
	if exist(options,'northarrow'),
		northarrow(options.getfieldvalue('northarrow'));
	end

	//curved arrow
	if exist(options,'curvedarrow'),
		curvedoptions=options.getfieldvalue('curvedarrow');
		curvedarrow(curvedoptions{:});
	end

	//Scale ruler
	if exist(options,'scaleruler'),
		scaleruler(options);
	end

	//streamliness
	if exist(options,'streamlines'),
		plot_streamlines(md,options);
	end

	//contours
	if exist(options,'contourlevels'),
		plot_contour(md,data,options);
	end

	//YTickLabel
	if exist(options,'yticklabel'),
		set(gca,'YTickLabel',options.getfieldvalue('YTickLabel'));
	end

	//XTickLabel
	if exist(options,'xticklabel'),
		set(gca,'XTickLabel',options.getfieldvalue('XTickLabel'));
	end

	//xtick
	if exist(options,'xtick'),
		set(gca,'xtick',options.getfieldvalue('xtick'));
	end

	//ytick
	if exist(options,'ytick'),
		set(gca,'ytick',options.getfieldvalue('ytick'));
	end

	//Axis positions
	if exist(options,'offsetaxispos'),
		offset=options.getfieldvalue('offsetaxispos');
		P=get(gca,'pos');
		P(1)=P(1)+offset(1);
		P(2)=P(2)+offset(2);
		P(3)=P(3)+offset(3);
		P(3)=P(4)+offset(4);
		set(gca,'pos',P);
	end
	if exist(options,'axispos'),
		Axis=options.getfieldvalue('axispos');
		hold on
		set(gca,'pos',Axis);
	end

	//axes position
	if exist(options,'axesPosition')
		set(gca,'Position',options.getfieldvalue('axesPosition'));
	end

	//showregion
	if strcmpi(options.getfieldvalue('showregion','off'),'on'),
		//Keep pointer of main axis
		maingca=gca;
		//get inset relative position (x,y,width,height)
		insetpos=options.getfieldvalue('insetpos',[0.02 0.70 0.18 0.18]);
		//get current plos position
		cplotpos=get(maingca,'pos');
		//compute inset position
		PosInset=[cplotpos(1)+insetpos(1)*cplotpos(3),cplotpos(2)+insetpos(2)*cplotpos(4), insetpos(3)*cplotpos(3), insetpos(4)*cplotpos(4)];
		axes('pos',PosInset);
		axis equal off
		//box off
		if md.mesh.epsg==3413,
			A=expread('/u/astrid-r1b/ModelData/Exp/GreenlandBoxFront.exp');
			[A.x A.y]=ll2xy(A.x,A.y,+1,45,70);
			A.x = A.x(1:30:end);
			A.y = A.y(1:30:end);
		elseif md.mesh.epsg==3031,
			A=expread('/u/astrid-r1b/ModelData/Exp/Antarctica.exp');
		else
			error('applyoptions error message: md.mesh.epsg not defined');
		end
		offset=3*10^4;
		Ax=[min(A.x)-offset max(A.x)+offset];
		Ay=[min(A.y)-offset max(A.y)+offset];
		//if we are zooming on a basin, don't take the mesh for the boundaries!
		if exist(options,'basin'),
			[mdx mdy]=basinzoom(options);
		else
			mdx=[min(md.mesh.x)-offset max(md.mesh.x)+offset];
			mdy=[min(md.mesh.y)-offset max(md.mesh.y)+offset];
		end
		line(A.x,A.y,ones(size(A.x)),'color','b');
		patch([Ax(1)  Ax(2)  Ax(2)  Ax(1) Ax(1)],[Ay(1)  Ay(1)  Ay(2)  Ay(2) Ay(1)],[1 1 1],'EdgeColor',[0 0 0],'LineWidth',1,'FaceLighting','none')
		patch([mdx(1) mdx(2) mdx(2) mdx(1)],[mdy(1) mdy(1) mdy(2) mdy(2)],ones(4,1),'EdgeColor',[0 0 0],'FaceColor','r','FaceAlpha',0.5)
		colorbar('off');
		//back to main gca
		set(gcf,'CurrentAxes',maingca)
	end

	//flag edges of a partition
	if exist(options,'partitionedges')
		[xsegments ysegments]=flagedges(md.mesh.elements,md.mesh.x,md.mesh.y,md.qmu.partition);
		xsegments=xsegments*options.getfieldvalue('unit',1);
		ysegments=ysegments*options.getfieldvalue('unit',1);
		color=options.getfieldvalue('partitionedgescolor','r-');
		linewidth=options.getfieldvalue('linewidth',1);
		hold on;
		for i=1:length(xsegments),
			plot(xsegments(i,:),ysegments(i,:),color,'LineWidth',linewidth);
		end
	end

	//Scatter
	if exist(options,'scatter')
		data=options.getfieldvalue('scatter');
		hold on
		plot_scatter(data(:,1),data(:,2),data(:,3),options);
	end

	//backgroundcolor
	set(gca,'color',options.getfieldvalue('backgroundcolor','none'));

	//lighting
	if strcmpi(options.getfieldvalue('light','off'),'on'),
		set(gca,'FaceLighting','gouraud','FaceColor','interp','AmbientStrength',0.5);
		light('Position',[0 0.1 0.1],'Style','infinite');
	end

	//cloud of points: 
	if exist(options,'cloud'),
		field=options.getfieldvalue('cloud');
		x=field(:,1);
		y=field(:,2);
		//unit multiplier:
		if exist(options,'unit'),
			unit=options.getfieldvalue('unit');
			x=x*unit;
			y=y*unit;
		end
		hold on,p=plot(x,y,'k.');
		markersize=options.getfieldvalue('markersize',12);
		color=options.getfieldvalue('cloudcolor','k');
		set(p,'Color',color);
		set(p,'MarkerSize',markersize);
	end

	//========================//
	//OK VERY LAST STEP: INSET|
	//========================//
	if exist(options,'inset'),

		//Keep pointer of main axis
		maingca=gca;
		//get inset relative position (x,y,width,height)
		insetpos=options.getfieldvalue('insetpos',[0.56 0.55 0.35 0.35]);
		//get current plot position
		cplotpos=get(gca,'pos');

		X1=options.getfieldvalue('insetx',xlim);
		Y1=options.getfieldvalue('insety',ylim);

		for i=1:length(options.getfieldvalue('insetx')),
			if length(insetpos)==4,
				insetposi=insetpos;
			else
				insetposi=insetpos{i};
			end
			PosInseti=[cplotpos(1)+insetposi(1)*cplotpos(3),cplotpos(2)+insetposi(2)*cplotpos(4), insetposi(3)*cplotpos(3), insetposi(4)*cplotpos(4)];
			//show pos
			if iscell(X1),
				X1i=X1{i};
			else
				X1i=X1;
			end
			if iscell(Y1),
				Y1i=Y1{i};
			else
				Y1i=Y1;
			end
			if strcmpi(options.getfieldvalue('showinset','off'),'on')
				line(X1i([1 2 2 1 1]),Y1i([1 1 2 2 1]),zeros(1,5),'Color','k','LineWidth',2);
			end

			//Get current figure
			ax1=gca;

			//plot inset
			axes('pos',PosInseti);
			copyobj(get(ax1,'children'),gca);
			patch('Faces',[1 2 3 4 1],'Vertices',[X1i([1 2 2 1])' Y1i([1 1 2 2])'],'FaceColor','None','EdgeColor','k','LineWidth',2);

			//apply options
			options=removefield(options,'text',0);
			options=removefield(options,'title',0);
			options=removefield(options,'xlabel',0);
			options=removefield(options,'ylabel',0);
			options=removefield(options,'inset',0);
			options=removefield(options,'offsetaxispos',0);
			options=removefield(options,'showregion',0);
			options=changefieldvalue(options,'colorbar',0);
			options=changefieldvalue(options,'latlon','off');
			options=changefieldvalue(options,'axis','equal off');
			options=changefieldvalue(options,'xlim',X1i);
			options=changefieldvalue(options,'ylim',Y1i);
			applyoptions(md,data,options);

			//back to main gca
			set(gcf,'CurrentAxes',maingca)
		end
	end
	*/ //}}}
}
