//MODEL class definition
//
//   Usage:
//      md = new model()

function model () {
	//methods
		this.disp = function() { //{{{
			console.log(sprintf("class model echo: "));
			console.log(sprintf("%19s: %-22s -- %s","mesh"            ,"[1x1 " + typeof(this.mesh) + "]","mesh properties"));
			console.log(sprintf("%19s: %-22s -- %s","mask"            ,"[1x1 " + typeof(this.mask) + "]","defines grounded and floating elements"));
			console.log(sprintf("%19s: %-22s -- %s","geometry"        ,"[1x1 " + typeof(this.geometry) + "]","surface elevation, bedrock topography, ice thickness,..."));
			console.log(sprintf("%19s: %-22s -- %s","constants"       ,"[1x1 " + typeof(this.constants) + "]","physical constants"));
			console.log(sprintf("%19s: %-22s -- %s","smb"             ,"[1x1 " + typeof(this.smb) + "]","surface mass balance"));
			console.log(sprintf("%19s: %-22s -- %s","basalforcings"   ,"[1x1 " + typeof(this.basalforcings) + "]","bed forcings"));
			console.log(sprintf("%19s: %-22s -- %s","materials"       ,"[1x1 " + typeof(this.materials) + "]","material properties"));
			console.log(sprintf("%19s: %-22s -- %s","damage"          ,"[1x1 " + typeof(this.damage) + "]","parameters for damage evolution solution"));
			console.log(sprintf("%19s: %-22s -- %s","friction"        ,"[1x1 " + typeof(this.friction) + "]","basal friction/drag properties"));
			console.log(sprintf("%19s: %-22s -- %s","flowequation"    ,"[1x1 " + typeof(this.flowequation) + "]","flow equations"));
			console.log(sprintf("%19s: %-22s -- %s","timestepping"    ,"[1x1 " + typeof(this.timestepping) + "]","time stepping for transient models"));
			console.log(sprintf("%19s: %-22s -- %s","initialization"  ,"[1x1 " + typeof(this.initialization) + "]","initial guess/state"));
			console.log(sprintf("%19s: %-22s -- %s","rifts"           ,"[1x1 " + typeof(this.rifts) + "]","rifts properties"));
			console.log(sprintf("%19s: %-22s -- %s","debug"           ,"[1x1 " + typeof(this.debug) + "]","debugging tools (valgrind, gprof)"));
			console.log(sprintf("%19s: %-22s -- %s","verbose"         ,"[1x1 " + typeof(this.verbose) + "]","verbosity level in solve"));
			console.log(sprintf("%19s: %-22s -- %s","settings"        ,"[1x1 " + typeof(this.settings) + "]","settings properties"));
			console.log(sprintf("%19s: %-22s -- %s","toolkits"        ,"[1x1 " + typeof(this.toolkits) + "]","PETSc options for each solution"));
			console.log(sprintf("%19s: %-22s -- %s","cluster"         ,"[1x1 " + typeof(this.cluster) + "]","cluster parameters (number of cpus...)"));
			console.log(sprintf("%19s: %-22s -- %s","balancethickness","[1x1 " + typeof(this.balancethickness) + "]","parameters for balancethickness solution"));
			console.log(sprintf("%19s: %-22s -- %s","stressbalance"   ,"[1x1 " + typeof(this.stressbalance) + "]","parameters for stressbalance solution"));
			console.log(sprintf("%19s: %-22s -- %s","groundingline"   ,"[1x1 " + typeof(this.groundingline) + "]","parameters for groundingline solution"));
			console.log(sprintf("%19s: %-22s -- %s","hydrology"       ,"[1x1 " + typeof(this.hydrology) + "]","parameters for hydrology solution"));
			console.log(sprintf("%19s: %-22s -- %s","masstransport"   ,"[1x1 " + typeof(this.masstransport) + "]","parameters for masstransport solution"));
			console.log(sprintf("%19s: %-22s -- %s","thermal"         ,"[1x1 " + typeof(this.thermal) + "]","parameters for thermal solution"));
			console.log(sprintf("%19s: %-22s -- %s","steadystate"     ,"[1x1 " + typeof(this.steadystate) + "]","parameters for steadystate solution"));
			console.log(sprintf("%19s: %-22s -- %s","transient"       ,"[1x1 " + typeof(this.transient) + "]","parameters for transient solution"));
			console.log(sprintf("%19s: %-22s -- %s","calving"         ,"[1x1 " + typeof(this.calving) + "]","parameters for calving"));
			console.log(sprintf("%19s: %-22s -- %s","gia"             ,"[1x1 " + typeof(this.gia) + "]","parameters for gia solution"));
			console.log(sprintf("%19s: %-22s -- %s","autodiff"        ,"[1x1 " + typeof(this.autodiff) + "]","automatic differentiation parameters"));
			console.log(sprintf("%19s: %-22s -- %s","flaim"           ,"[1x1 " + typeof(this.flaim) + "]","flaim parameters"));
			console.log(sprintf("%19s: %-22s -- %s","inversion"       ,"[1x1 " + typeof(this.inversion) + "]","parameters for inverse methods"));
			console.log(sprintf("%19s: %-22s -- %s","qmu"             ,"[1x1 " + typeof(this.qmu) + "]","dakota properties"));
			console.log(sprintf("%19s: %-22s -- %s","outputdefinition","[1x1 " + typeof(this.outputdefinition) + "]","output definition"));
			console.log(sprintf("%19s: %-22s -- %s","results"         ,"[1x1 " + typeof(this.results) + "]","model results"));
			console.log(sprintf("%19s: %-22s -- %s","radaroverlay"    ,"[1x1 " + typeof(this.radaroverlay) + "]","radar image for plot overlay"));
			console.log(sprintf("%19s: %-22s -- %s","miscellaneous"   ,"[1x1 " + typeof(this.miscellaneous) + "]","miscellaneous fields"));
		} //}}}
		this.setdefaultparameters = function () { // {{{

			//initialize subclasses
			this.mesh             = new mesh2d();
			this.mask             = new mask();
			this.constants        = new constants();
			this.geometry         = new geometry();
			this.initialization   = new initialization();
			this.smb              = new SMBforcing();
			this.basalforcings    = new basalforcings();
			this.friction         = new friction();
			this.rifts            = new rifts();
			this.timestepping     = new timestepping();
			this.groundingline    = new groundingline();
			this.materials        = new matice();
			this.damage           = new damage();
			this.flowequation     = new flowequation();
			this.debug            = new debug();
			this.verbose          = new verbose();
			this.settings         = new settings();
			this.toolkits         = new toolkits();
			this.cluster          = new local();
			this.balancethickness = new balancethickness();
			this.stressbalance    = new stressbalance();
			this.hydrology        = new hydrologyshreve();
			this.masstransport    = new masstransport();
			this.thermal          = new thermal();
			this.steadystate      = new steadystate();
			this.transient        = new transient();
			this.calving          = new calving();
			this.gia              = new gia();
			this.autodiff         = new autodiff();
			this.flaim            = new flaim();
			this.inversion        = new inversion();
			this.qmu              = new qmu();
			this.radaroverlay     = new radaroverlay();
			this.results          = [];
			this.outputdefinition = new outputdefinition();
			this.miscellaneous    = new miscellaneous();
			this.private          = new private();
		} //}}}
		this.checkmessage = function(string){ //{{{
			console.log('model not consistent: ' + string);
			md.private.isconsistent=false;
		} //}}}
	//properties
	// {{{
		//Careful here: no other class should be used as default value this is a bug of matlab
		this.mesh             = 0;
		this.mask             = 0;

		this.geometry         = 0;
		this.constants        = 0;
		this.smb              = 0;
		this.basalforcings    = 0;
		this.materials        = 0;
		this.damage           = 0;
		this.friction         = 0;
		this.flowequation     = 0;
		this.timestepping     = 0;
		this.initialization   = 0;
		this.rifts            = 0;

		this.debug            = 0;
		this.verbose          = 0;
		this.settings         = 0;
		this.toolkits         = 0;
		this.cluster          = 0;

		this.balancethickness = 0;
		this.stressbalance    = 0;
		this.groundingline    = 0;
		this.hydrology        = 0;
		this.masstransport    = 0;
		this.thermal          = 0;
		this.steadystate      = 0;
		this.transient        = 0;
		this.calving          = 0;
		this.gia              = 0;

		this.autodiff         = 0;
		this.flaim            = 0;
		this.inversion        = 0;
		this.qmu              = 0;

		this.results          = 0;
		this.outputdefinition = 0;
		this.radaroverlay     = 0;
		this.miscellaneous    = 0;
		this.private          = 0;

		//set default values for fields
		this.setdefaultparameters();

		//}}}
}
