function solve(md,solutionenum){
//SOLVE - apply solution sequence for this model
//
//   Usage:
//      solve(md,solutionenum,varargin)
//      where varargin is a lit of paired arguments of string OR enums
//
//   solution types available comprise:
//		 - StressbalanceSolutionEnum
//		 - MasstransportSolutionEnum
//		 - ThermalSolutionEnum
//		 - SteadystateSolutionEnum
//		 - TransientSolutionEnum
//		 - BalancethicknessSolutionEnum
//		 - BedSlopeSolutionEnum
//		 - SurfaceSlopeSolutionEnum
//		 - HydrologySolutionEnum
//		 - FlaimSolutionEnum
//
//  extra options:
//      - loadonly    : does not solve. only load results
//      - runtimename : true or false (default is true), makes name unique
//      - checkconsistency : 'yes' or 'no' (default is 'yes'), ensures checks on consistency of model
//      - restart: 'directory name (relative to the execution directory) where the restart file is located.
//
//   Examples:
//      md=solve(md,StressbalanceSolutionEnum);

	solutionstring=EnumToString(solutionenum);
	
	//recover and process solve options
	if (solutionstring.slice(-8) !== 'Solution'){
		throw Error(sprintf("%s%s%s\n",'solutionenum ',solutionstring,' not supported!'));
	}
	
	//Process options
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args.slice(2,args.length));
	options.addfield('solutionenum',solutionenum);

	//recover some fields
	md.private.solution=solutionenum;
	cluster=md.cluster;

	//check model consistency
	if (options.getfieldvalue('checkconsistency','yes') == 'yes'){
		if (md.verbose.solution){
			console.log('checking model consistency');
		}
		if (solutionenum == FlaimSolutionEnum()){
			md.private.isconsistent=true;
			md.mesh.checkconsistency(md,solutionenum);
			md.flaim.checkconsistency(md,solutionenum);
			if (md.private.isconsistent==false){
				throw error('solve error message: model not consistent, see messages above');
			}
		}
		else{
			ismodelselfconsistent(md);
		}
	}

	//If we are restarting, actually use the provided runtime name:
	restart=options.getfieldvalue('restart','');
	//First, build a runtime name that is unique
	if (restart==1 ){
		//Leave the runtimename as is
		}
	else{
		if (!(restart == '')){
			md.private.runtimename=restart;
		}
		else if (options.getfieldvalue('runtimename',true)){
			c=new Date().getTime();
			md.private.runtimename=sprintf('%s-%g',md.miscellaneous.name,c);
		}
		else{
			md.private.runtimename=md.miscellaneous.name;
		}
	}

	//if running qmu analysis, some preprocessing of dakota files using models
	//fields needs to be carried out. 
	if (md.qmu.isdakota){
		throw Error("solve error message: qmu runs not supported yet!");
		//md.preqmu(options);
	}

	//flaim analysis (To be removed?)
	if (solutionenum == FlaimSolutionEnum()){
		//fmdir     = options.getfieldvalue('fmdir',['fm' num2str(feature('GetPid'))]);
		//overwrite = options.getfieldvalue('overwrite','n');
		//keep      = options.getfieldvalue('keep','y');
		//latsgn    = options.getfieldvalue('latsgn',0);
		//cmap      = options.getfieldvalue('cmap',[]);
		throw  Error("solve error message: flaim runs not supported yet!");
		//flaim_sol(md,options);
		//md.private.solution=EnumToString(solutionenum);
		//return;
	}

	//Do we load results only?
	if (options.getfieldvalue('loadonly',false)){
		loadresultsfromcluster(md);
		return;
	}

	//Write all input files
	fid = marshall(md);                                          // bin file
	toolkitsstring= md.toolkits.ToolkitsFile(md.miscellaneous.name + '.toolkits'); // toolkits file

	if (cluster.classname() != 'local'){ //{{{

		throw Error('non local clusters not supported yet!');

		cluster.BuildQueueScript(md.private.runtimename,md.miscellaneous.name,md.private.solution,md.settings.io_gather,md.debug.valgrind,md.debug.gprof,md.qmu.isdakota); // queue file

		//Stop here if batch mode
		if (options.getfieldvalue('batch','no') === 'yes'){
			if (md.verbose.solution){
				console.log('batch mode requested: not launching job interactively');
				console.log('launch solution sequence on remote cluster by hand');
			}
			return;
		}

		//Upload all required files
		modelname = md.miscellaneous.name;
		filelist  = [modelname + '.bin ',modelname + '.toolkits '];
		if (ispc){
			filelist.push(modelname + '.bat ');
		}
		else{
			filelist.push(modelname + '.queue ');
		}

		if (md.qmu.isdakota){
			filelist.push(modelname + '.qmu.in');
		}

		if (restart == ''){
			cluster.UploadQueueJob(md.miscellaneous.name,md.private.runtimename,filelist);
		}

		//launch queue job: 
		cluster.LaunchQueueJob(md.miscellaneous.name,md.private.runtimename,filelist,restart);

		//wait on lock
		if (md.settings.waitonlock == 'NaN'){
			//load when user enters 'y'
			console.log('solution launched on remote cluster. log in to detect job completion.');
			throw Error("solve error message: user detection of successfull completion of job not support yet!");
			/*choice=input('Is the job successfully completed? (y/n)','s');
			  if ~strcmp(choice,'y'), 
			  console.log('Results not loaded... exiting'); 
			  else
			  md=loadresultsfromcluster(md);
			  end*/
		}
		else if (md.settings.waitonlock>0){
			//we wait for the done file
			done=waitonlock(md);
			if (md.verbose.solution){
				console.log('loading results from cluster');
			}
			loadresultsfromcluster(md);
		}
		else if (md.settings.waitonlock==0){
			console.log('Model results must be loaded manually with md=loadresultsfromcluster(md);');
		}

		//post processes qmu results if necessary
		if (md.qmu.isdakota){
			/*if ~strncmpi(options.getfieldvalue('keep','y'),'y',1)
			  system(['rm -rf qmu' num2str(feature('GetPid'))]);
			  end*/
		}
	} //}}}
	else{ //if (cluster.classname() == 'local') 

		/*We are running locally on the machine, using the issm module:*/
		console.log('running issm locally');
		
		//Call issm:
		issm(fid, toolkitsstring, solutionstring, md.miscellaneous.name);
	}
}
