//FILEPTR class definition
////
//// Usage: 
//// var fid = new fileptr(); 
//
//

function fileptr() {
	//properties
	this.increment=NaN;
	this.buffer =NaN;
	this.view =NaN;
	this.ptr =NaN;
	this.options = new pairoptions(Array.prototype.slice.call(arguments));
	
	//methods
		this.disp = function () { //{{{
			console.log(sprintf("   fileptr:")); 

			console.log(sprintf("       buffer: ArrayBuffer{ byteLength: %i }\n",this.buffer.byteLength));
			console.log(sprintf("       ptr: %i\n",this.ptr));
			console.log(sprintf("       increment: %i\n",this.increment));

		} //}}}
		this.setdefaultparameters = function (options) { //{{{

			this.increment=options.getfieldvalue('increment',80000); //80000 bytes,  10000 doubles.
			this.buffer=new ArrayBuffer(this.increment);
			this.ptr=0;
			this.view=new DataView(this.buffer);

		} //}}}
		this.fwrite = function (value,format) { //{{{

			
			if(format == 'int'){
				if(this.ptr+4>=this.buffer.byteLength)this.resize();
				this.view.setUint32(this.ptr,value,true); this.ptr+=4;
			}
			else if(format == 'char'){
				if(this.ptr+value.length>=this.buffer.byteLength)this.resize();
				for(var i=0;i<value.length;i++){
					this.view.setUint8(this.ptr,value.charCodeAt(i),true); 
					this.ptr+=1;
				}
			}
			else if(format == 'double'){
				if(this.ptr+8>=this.buffer.byteLength)this.resize();
				if (!IsArray(value)){
					this.view.setFloat64(this.ptr,value,true);
					this.ptr+=8;
				}
				else{
					if (!IsArray(value[0])){
						if(this.ptr+value.length*8>=this.buffer.byteLength)this.resize();
						for(var i=0;i<value.length;i++){
							this.view.setFloat64(this.ptr,value[i],true);
							this.ptr+=8;
						}
					}
					else{
						if(this.ptr+value.length*value[0].length*8>=this.buffer.byteLength)this.resize();
						for(var i=0;i<value.length;i++){
							for(var j=0;j<value[0].length;j++){
								this.view.setFloat64(this.ptr,value[i][j],true);
								this.ptr+=8;
							}
						}
					}
				}
			}
			else throw Error('fileptr.fwrite error message: wrong type of format');
		} //}}}
		this.rawbuffer = function () { //{{{
			return this.buffer;
		} //}}}
		this.resize = function () { //{{{
			var  newbuffer = new ArrayBuffer(this.buffer.byteLength+this.increment);
			new Uint8Array(newbuffer).set(new Uint8Array(this.buffer));
			this.buffer=newbuffer;
			this.view=new DataView(this.buffer);
		} //}}}
	//set defaults
	this.setdefaultparameters(this.options);
}
