//BASAL FORCINGS class definition
//
//   Usage:
//      basalforcings=basalforcings();

function basalforcings(){
	//methods
	this.setdefaultparameters = function() {//{{{

	} // }}}
	this.disp = function(){ // {{{
		console.log(sprintf('   basal forcings parameters:'));

		fielddisplay(this,'groundedice_melting_rate','basal melting rate (positive if melting) [m/yr]');
		fielddisplay(this,'floatingice_melting_rate','basal melting rate (positive if melting) [m/yr]');
		fielddisplay(this,'geothermalflux','geothermal heat flux [W/m^2]');

	} // }}}
	this.classname = function(){ // {{{
		return "basalforcings";
	} // }}}
		this.initialize = function (md){ // {{{

			if (this.groundedice_melting_rate === NaN){
				this.groundedice_melting_rate=NewArrayFill(md.mesh.numberofvertices,0);
				console.log('      no basalforcings.groundedice_melting_rate specified: values set as zero');
			}

			if (this.floatingice_melting_rate === NaN){
				this.floatingice_melting_rate=NewArrayFill(md.mesh.numberofvertices,0);
				console.log('      no basalforcings.floatingice_melting_rate specified: values set as zero');
			}

		} // }}}
		this.checkconsistency = function(md,solution,analyses) { //{{{

			if(ArrayAnyEqual(ArrayIsMember(MasstransportAnalysisEnum(),analyses),1)){
				if (!(solution==TransientSolutionEnum() & md.transient.ismasstransport==0)){
					checkfield(md,'fieldname','basalforcings.groundedice_melting_rate','NaN',1,'timeseries',1);
					checkfield(md,'fieldname','basalforcings.floatingice_melting_rate','NaN',1,'timeseries',1);
				}
			}

			if(ArrayAnyEqual(ArrayIsMember(BalancethicknessAnalysisEnum(),analyses),1)){
				checkfield(md,'fieldname','basalforcings.groundedice_melting_rate','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','basalforcings.floatingice_melting_rate','NaN',1,'size',[md.mesh.numberofvertices, 1]);
			}
			if(ArrayAnyEqual(ArrayIsMember(ThermalAnalysisEnum(),analyses),1)){
				if (!(solution==TransientSolutionEnum() & md.transient.isthermal==0)){
					checkfield(md,'fieldname','basalforcings.groundedice_melting_rate','NaN',1,'timeseries',1);
					checkfield(md,'fieldname','basalforcings.floatingice_melting_rate','NaN',1,'timeseries',1);
					checkfield(md,'fieldname','basalforcings.geothermalflux','NaN',1,'timeseries',1,'>=',0);
				}
			}
		} // }}}
		this.marshall=function(md,fid) { //{{{

			var yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',BasalforcingsEnum(),'data',FloatingMeltRateEnum(),'format','Integer');
			WriteData(fid,'object',this,'fieldname','groundedice_melting_rate','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',this,'fieldname','floatingice_melting_rate','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',this,'fieldname','geothermalflux','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
		}//}}}
	//properties
	//{{{
	this.groundedice_melting_rate  = NaN;
	this.floatingice_melting_rate  = NaN;
	this.geothermalflux            = NaN;
	this.setdefaultparameters();
	//}}}
}
