//SMBforcing Class definition
//
//   Usage:
//      SMB=SMBforcing();

function SMBforcing(){
	//methods
	this.setdefaultparameters = function(){// {{{
	} // }}}
	this.disp = function(){ // {{{
		console.log(sprintf('   surface forcings parameters:'));
		fielddisplay(this,'mass_balance','surface mass balance [m/yr ice eq]');
		fielddisplay(this,'requested_outputs','additional outputs requested');
	} // }}}
	this.defaultoutputs = function(){ // {{{
		return '';
	}//}}}
this.classname = function(){ // {{{
	return "SMBforcing";
} // }}}
		this.initialize = function(md) {// {{{

			if (self.mass_balance === NaN){
				self.mass_balance=NewArrayFill(md.mesh.numberofvertices,0);
				console.log('      no smb.mass_balance specified: values set as zero');
			}

		} // }}}
		this.checkconsistency = function(md,solution,analyses) { //{{{

			if(ArrayAnyEqual(ArrayIsMember(MasstransportAnalysisEnum(),analyses),1)){
				checkfield(md,'fieldname','smb.mass_balance','timeseries',1,'NaN',1);
			}
			if(ArrayAnyEqual(ArrayIsMember(BalancethicknessAnalysisEnum(),analyses),1)){
				checkfield(md,'fieldname','smb.mass_balance','size',[md.mesh.numberofvertices,1],'NaN',1);
			}
			checkfield(md,'fieldname','smb.requested_outputs','stringrow',1);

		} // }}}
		this.marshall=function(md,fid) { //{{{

			var yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SmbEnum(),'data',SMBforcingEnum(),'format','Integer');
			WriteData(fid,'object',this,'class','smb','fieldname','mass_balance','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1);
			
			//process requested outputs
			outputs = this.requested_outputs;
			for (var i=0;i<outputs;i++){
				if (outputs[i] == 'default') {
					outputs.splice(i,1);
					outputs.push(this.defaultoutputs());
				}
			}
			WriteData(fid,'data',outputs,'enum',SmbRequestedOutputsEnum,'format','StringArray');

		}//}}}
	//properties 
	this.mass_balance = NaN;
	this.requested_outputs      = [''];
	this.setdefaultparameters();
}
