function nightlyrun(varargin)
%NIGHTLYRUN - run the nighlty tests on 'tests/Verification'
%
%   This function goes to each directory of 'tests/Verifications' and
%   launch the nightly tests. A specific package can be given in input
%   only this package will be tested
%   if last arguments are a pair of numbers, they represent the node rank and the number of 
%   cpus being used for the nightly run.
%
%  Usage:
%      nightlyrun(varargin)
%
%   Example:
%      nightlyrun;
%      nightlyrun({'ice'});
%      nightlyrun({'cielo_serial','cielo_parallel'});
%      nightlyrun({'ice'},{'prognostic','diagnostic'});
%      nightlyrun({'ice'},{'prognostic','diagnostic'},1,3);

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%check number of inputs
if nargin==0,
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
	rank=1;
	numprocs=1;
elseif nargin==1,
	packages=varargin{1};
	rank=1;
	numprocs=1;
elseif nargin==3,
	packages=varargin{1};
	rank=varargin{end-1};
	numprocs=varargin{end};
	if ~isnumeric(rank), rank=1; end
	if ~isnumeric(numprocs), numprocs=1; end
else
	help nightlyrun
	error('nightlyrun error message: bad usage');
end

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

list=listfilesparallel(rank,numprocs);

%Go through list of decks, and run the deck runme.m files package by package.
for i=1:length(packages),
	for j=1:numel(list),
		eval(['cd ' list{j}]);
		if nargin==2,
			runme(packages(i),varargin{2});
		else
			runme(packages(i));
		end
		cd ..
	end
end

%display needed by nightlyrun.sh to check that no error popped up.
disp('NIGHTLYRUNTERMINATEDCORRECTLY');
