function ismodelselfconsistent(md){
//ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
//
//   Usage:
//      ismodelselfconsistent(md),

	//initialize consistency as true
	md.private.isconsistent=true;

	//Get solution and associated analyses
	solution=md.private.solution;
	var analyses = AnalysisConfiguration(solution);

	//Go through a model field, check that it is a class, and call checkconsistency
	for(field in md){

		//Some properties do not need to be checked
		if (field == 'results' | field == 'debug' | field == 'radaroverlay'){
			continue;
		}

		//Check that current field is a class
		if(typeof md[field] == 'function'){
			continue;
		}

		//Check consistency of the class
		md[field].checkconsistency(md,solution,analyses);
	}

	//error message if mode is not consistent
	if (md.private.isconsistent==false){
		throw Error('Model not consistent, see messages above');
	}
}

function AnalysisConfiguration(solutiontype){ // {{{
	//ANALYSISCONFIGURATION - return type of analyses, number of analyses 
	//
	//   Usage:
	//      [analyses]=AnalysisConfiguration(solutiontype);

	var analyses=[];
	switch (solutiontype){

		case StressbalanceSolutionEnum():
			analyses=[StressbalanceAnalysisEnum(),StressbalanceVerticalAnalysisEnum(),StressbalanceSIAAnalysisEnum(),L2ProjectionBaseAnalysisEnum()];
			break;

		case SteadystateSolutionEnum():
			analyses=[StressbalanceAnalysisEnum(),StressbalanceVerticalAnalysisEnum(),StressbalanceSIAAnalysisEnum(),L2ProjectionBaseAnalysisEnum(),ThermalAnalysisEnum(),MeltingAnalysisEnum()];
			break;

		case ThermalSolutionEnum():
			analyses=[EnthalpyAnalysisEnum(),ThermalAnalysisEnum(),MeltingAnalysisEnum()];
			break;

		case MasstransportSolutionEnum():
			analyses=[MasstransportAnalysisEnum()];
			break;

		case BalancethicknessSolutionEnum():
			analyses=[BalancethicknessAnalysisEnum()];
			break;

		case Balancethickness2SolutionEnum():
			analyses=[Balancethickness2AnalysisEnum()];
			break;

		case BalancethicknessSoftSolutionEnum():
			analyses=[BalancethicknessAnalysisEnum()];
			break;

		case BalancevelocitySolutionEnum():
			analyses=[BalancevelocityAnalysisEnum()];
			break;

		case SurfaceSlopeSolutionEnum():
			analyses=[L2ProjectionBaseAnalysisEnum()];
			break;

		case BedSlopeSolutionEnum():
			analyses=[L2ProjectionBaseAnalysisEnum()];
			break;

		case GiaSolutionEnum():
			analyses=[GiaAnalysisEnum()];
			break;

		case TransientSolutionEnum():
			analyses=[StressbalanceAnalysisEnum(),StressbalanceVerticalAnalysisEnum(),StressbalanceSIAAnalysisEnum(),L2ProjectionBaseAnalysisEnum(),ThermalAnalysisEnum(),MeltingAnalysisEnum(),EnthalpyAnalysisEnum(),MasstransportAnalysisEnum(),HydrologySommersAnalysisEnum];
			break;

		case FlaimSolutionEnum():
			analyses=[FlaimAnalysisEnum()];
			break;

		case HydrologySolutionEnum():
			analyses=[L2ProjectionBaseAnalysisEnum(),HydrologyShreveAnalysisEnum(),HydrologyDCInefficientAnalysisEnum(),HydrologyDCEfficientAnalysisEnum()];
			break;

		case DamageEvolutionSolutionEnum():
			analyses=[DamageEvolutionAnalysisEnum()];
			break;

		default:
			throw Error(sprintf("%s%s%s\n",' solution type: ',EnumToString(solutiontype),' not supported yet!'));
	}
	return analyses;
} // }}}
