//STEADYSTATE class definition
//
//   Usage:
//      steadystate=new steadystate();

function steadystate (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//maximum of steady state iterations
		this.maxiter=100;

		//Relative tolerance for the steadystate convertgence
		this.reltol=0.01;

		//default output
		this.requested_outputs=['default'];


	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   steadystate solution parameters:'));

		fielddisplay(this,'reltol','relative tolerance criterion');
		fielddisplay(this,'maxiter','maximum number of iterations');
		fielddisplay(this,'requested_outputs','additional requested outputs');

	}// }}}
	this.checkconsistency = function(md,solution,analyses) {// {{{

		//Early return
		if (solution!=SteadystateSolutionEnum()) return;

		if (md.timestepping.time_step!=0){
			md.checkmessage('for a steadystate computation, timestepping.time_step must be zero.');
		}
		checkfield(md,'fieldname','steadystate.requested_outputs','stringrow',1);

		if (isNaN(md.stressbalance.reltol)){
			md.checkmessage('for a steadystate computation, stressbalance.reltol (relative convergence criterion) must be defined!');
		}
	} // }}}
	//properties 
	// {{{

	this.reltol            = 0;
	this.maxiter           = 0;
	this.requested_outputs = [];

	this.setdefaultparameters();
	//}}}
}
