//SETTINGS class definition
//
//   Usage:
//      settings=new settings();

function settings (){
	//methods
	this.setdefaultparameters = function(){// {{{
		//are we short in memory ? (0 faster but requires more memory)
		this.lowmem=0;

		//i/o:
		this.io_gather=1;

		//results frequency by default every step
		this.output_frequency=1;

		//checkpoints frequency, by default never: 
		this.recording_frequency=0;

		//this option can be activated to load automatically the results
		//onto the model after a parallel run by waiting for the lock file
		//N minutes that is generated once the solution has converged
		//0 to deactivate
		this.waitonlock=Infinity;

		//upload options: 
		upload_port         = 0;

	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   settings class echo:'));

	}// }}}
		this.checkconsistency = function(md,solution,analyses) { // {{{

			checkfield(md,'fieldname','settings.results_on_nodes','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','settings.io_gather','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','settings.lowmem','numel',[1],'values',[0, 1]);
			checkfield(md,'fieldname','settings.output_frequency','numel',[1],'>=',1);
			checkfield(md,'fieldname','settings.recording_frequency','numel',[1],'>=',0);
			checkfield(md,'fieldname','settings.waitonlock','numel',[1]);
		} // }}}
	//properties 
	// {{{
	this.results_on_nodes    = 0;
	this.io_gather           = 0;
	this.lowmem              = 0;
	this.output_frequency    = 0;
	this.recording_frequency   = 0;
	this.waitonlock          = 0;
	this.upload_server       = '';
	this.upload_path         = '';
	this.upload_login        = '';
	this.upload_port         = 0;
	this.upload_filename     = '';
	this.setdefaultparameters();
	//}}}
}
