//FILEPTR class definition
////
//// Usage: 
//// var fid = new fileptr(); 
//
//

function fileptr() {
	//properties
	this.increment=NaN;
	this.buffer =NaN;
	this.view =NaN;
	this.ptr =NaN;
	this.options = new pairoptions(Array.prototype.slice.call(arguments));
	
	//methods
		this.disp = function () { //{{{
			console.log(sprintf("   fileptr:")); 

			console.log(sprintf("       buffer: ArrayBuffer{ byteLength: %i }\n",this.buffer.byteLength));
			console.log(sprintf("       ptr: %i\n",this.ptr));
			console.log(sprintf("       increment: %i\n",this.increment));

		} //}}}
		this.setdefaultparameters = function (options) { //{{{

			this.increment=options.getfieldvalue('increment',8000); //8000 bytes,  1000 doubles.
			this.buffer=new ArrayBuffer(this.increment);
			this.ptr=0;
			this.view=new DataView(this.buffer);

		} //}}}
		this.fwrite = function (value,format) { //{{{

			if(this.ptr==this.buffer.byteLength){
				//need to resize the buffer: 
				var  newbuffer = new ArrayBuffer(this.buffer.byteLength+this.increment);
				newbuffer.set(this.buffer);
				this.buffer=newbuffer;
			}
			
			if(format == 'int'){
				this.view.setUint32(this.ptr,value,true); this.ptr+=4;
			}
			else if(format == 'char'){
				for(var i=0;i<value.length;i++){
					this.view.setUint8(this.ptr,value.charCodeAt(i),true); 
					this.ptr+=1;
				}
			}
			else if(format == 'double'){
				if (!IsArray(value)){
					this.view.setFloat64(this.ptr,value,true);
					this.ptr+=8;
				}
				else{
					if (!IsArray(value[0])){
						for(var i=0;i<value.length;i++){
							this.view.setFloat64(this.ptr,value[i],true);
							this.ptr+=8;
						}
					}
					else{
						for(var i=0;i<value.length;i++){
							for(var j=0;j<value[0].length;j++){
								this.view.setFloat64(this.ptr,value[i][j],true);
								this.ptr+=8;
							}
						}
					}
				}
			}
			else throw Error('fileptr.fwrite error message: wrong type of format');
		} //}}}
		this.rawbuffer = function () { //{{{
			return this.buffer;
		} //}}}
	//set defaults
	this.setdefaultparameters(this.options);
}
