//VERBOSE class definition
//
//   Available verbosity levels:
//      mprocessor  : model processing 
//      module      : modules
//      solution    : solution sequence
//      solver      : solver info (extensive)
//      convergence : convergence criteria
//      control     : control method
//      qmu         : sensitivity analysis
//      autodiff    : AD analysis
//      smb         : smb analysis
//
//   Usage:
//      verbose=verbose();
//      verbose=verbose(3);
//      verbose=verbose('all');
//      verbose=verbose('001100');
//      verbose=verbose('module',true,'solver',false);

//WARNING: some parts of this file are Synchronized with src/c/shared/Numerics/Verbosity.h
//         Do not modify these sections. See src/c/shared/Numerics/README for more info

function verbose (){
	//methods
	this.setdefaultparameters = function(){// {{{
	}// }}}
	this.disp= function(){// {{{
		//BEGINDISP
		console.log(sprintf('verbose class echo:'));
		console.log(sprintf('   %15s : %s','mprocessor',mat2str(verbose.mprocessor)));
		console.log(sprintf('   %15s : %s','module',mat2str(verbose.module)));
		console.log(sprintf('   %15s : %s','solution',mat2str(verbose.solution)));
		console.log(sprintf('   %15s : %s','solver',mat2str(verbose.solver)));
		console.log(sprintf('   %15s : %s','convergence',mat2str(verbose.convergence)));
		console.log(sprintf('   %15s : %s','control',mat2str(verbose.control)));
		console.log(sprintf('   %15s : %s','qmu',mat2str(verbose.qmu)));
		console.log(sprintf('   %15s : %s','autodiff',mat2str(verbose.autodiff)));
		console.log(sprintf('   %15s : %s','smb',mat2str(verbose.smb)));
		//ENDDISP
	}// }}}
		this.checkconsistency = function(md,solution,analyses){ // {{{

		} // }}}
	//properties 
	// {{{
	//BEGINFIELDS
	this.mprocessor=false;
	this.module=false;
	this.solution=false;
	this.solver=false;
	this.convergence=false;
	this.control=false;
	this.qmu=false;
	this.autodiff=false;
	this.smb=false;
	//ENDFIELDS
	// }}}
	this.setdefaultparameters();
	//}}}
}
