//MASSTRANSPORT class definition
//
//   Usage:
//      masstransport=new masstransport();

function masstransport (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//Type of stabilization to use 0:nothing 1:artificial_diffusivity 3:Discontinuous Galerkin
		this.stabilization=1;

		//Factor applied to compute the penalties kappa=max(stiffness matrix)*10^penalty_factor
		this.penalty_factor=3;

		//Minimum ice thickness that can be used
		this.min_thickness=1;

		//Hydrostatic adjustment
		this.hydrostatic_adjustment='Absolute';

		//default output
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   Masstransport solution parameters:'));
		fielddisplay(this,'spcthickness','thickness constraints (NaN means no constraint) [m]');
		fielddisplay(this,'isfreesurface','do we use free surfaces (FS only) are mass conservation');
		fielddisplay(this,'min_thickness','minimum ice thickness allowed [m]');
		fielddisplay(this,'hydrostatic_adjustment',"adjustment of ice shelves surface and bed elevations: 'Incremental' or 'Absolute' ");
		fielddisplay(this,'stabilization','0: no, 1: artificial_diffusivity, 2: streamline upwinding, 3: discontinuous Galerkin, 4: Flux Correction Transport');

		console.log(sprintf('\n      %s','Penalty options:'));
		fielddisplay(this,'penalty_factor','offset used by penalties: penalty = Kmax*10^offset');
		fielddisplay(this,'vertex_pairing','pairs of vertices that are penalized');
		fielddisplay(this,'requested_outputs','additional outputs requested');

	}// }}}
		this.checkconsistency = function (md,solution,analyses){  // {{{

			//Early return
			if(!ArrayAnyEqual(ArrayIsMember(HydrologyShreveAnalysisEnum(),analyses),1) | (solution==TransientSolutionEnum() & md.transient.ismasstransport==0)) return; 

			checkfield(md,'fieldname','masstransport.spcthickness','timeseries',1);
			checkfield(md,'fieldname','masstransport.isfreesurface','values',[0 ,1]);
			checkfield(md,'fieldname','masstransport.hydrostatic_adjustment','values',['Absolute', 'Incremental']);
			checkfield(md,'fieldname','masstransport.stabilization','values',[0,1,2,3,4]);
			checkfield(md,'fieldname','masstransport.min_thickness','>',0);
			checkfield(md,'fieldname','masstransport.requested_outputs','stringrow',1);

		} // }}}
	//properties 
	// {{{

	this.spcthickness           = NaN;
	this.isfreesurface          = 0;
	this.min_thickness          = 0;
	this.hydrostatic_adjustment = 0;
	this.stabilization          = 0;
	this.vertex_pairing         = NaN;
	this.penalty_factor         = 0;
	this.requested_outputs      = [''];

	this.setdefaultparameters();
	//}}}
}
