//CALVING class definition
//
//   Usage:
//      calving=new calving();

function calving (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//stabilization = 2 by default
		this.stabilization = 2;
	
	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   Calving parameters:'));
		fielddisplay(this,'stabilization','0: no, 1: artificial_diffusivity, 2: streamline upwinding');
		fielddisplay(this,'spclevelset','Levelset constraints (NaN means no constraint)');
		fielddisplay(this,'calvingrate','calving rate at given location [m/a]');
		fielddisplay(this,'meltingrate','melting rate at given location [m/a]');

	}// }}}
	this.checkconsistency = function(md,solution,analyses) { // {{{
		//Early return
		if (solution!=TransientSolutionEnum() | md.transient.iscalving==0) return;

		checkfield(md,'fieldname','calving.spclevelset','timeseries',1);
		checkfield(md,'fieldname','calving.stabilization','values',[0,1,2]);
		checkfield(md,'fieldname','calving.calvingrate(1:md.mesh.numberofvertices,:)','>=',0,'timeseries',1,'NaN',1);
		checkfield(md,'fieldname','calving.meltingrate(1:md.mesh.numberofvertices,:)','>=',0,'timeseries',1,'NaN',1);
	} //}}}
	//properties 
	// {{{

	this.stabilization = 0;
	this.spclevelset   = NaN;
	this.calvingrate   = NaN;
	this.meltingrate   = NaN;

	this.setdefaultparameters();
	//}}}
}
