//AUTODIFF class definition
//
//   Usage:
//      autodiff=new autodiff();

function autodiff (){
	//methods
	this.setdefaultparameters = function(){// {{{

		this.obufsize     = 524288;
		this.lbufsize     = 524288;
		this.cbufsize     = 524288;
		this.tbufsize     = 524288;
		this.gcTriggerRatio=2.0;
		this.gcTriggerMaxSize=65536;

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   automatic differentiation parameters:'));
		fielddisplay(this,'isautodiff','indicates if the automatic differentiation is activated');
		fielddisplay(this,'dependents','list of dependent variables');
		fielddisplay(this,'independents','list of independent variables');
		fielddisplay(this,'driver',"ADOLC driver ('fos_forward' or 'fov_forward')");
		fielddisplay(this,'obufsize','Number of operations per buffer (==OBUFSIZE in usrparms.h)');
		fielddisplay(this,'lbufsize','Number of locations per buffer (==LBUFSIZE in usrparms.h)');
		fielddisplay(this,'cbufsize','Number of values per buffer (==CBUFSIZE in usrparms.h)');
		fielddisplay(this,'tbufsize','Number of taylors per buffer (<=TBUFSIZE in usrparms.h)');
		fielddisplay(this,'gcTriggerRatio','free location block sorting/consolidation triggered if the ratio between allocated and used locations exceeds gcTriggerRatio');
		fielddisplay(this,'gcTriggerMaxSize','free location block sorting/consolidation triggered if the allocated locations exceed gcTriggerMaxSize');

	}// }}}
		this.checkconsistency = function(md,solution,analyses){ //{{{

			//Early return 
			if (!this.isautodiff) return; 

			//Driver value:
			checkfield(md,'fieldname','autodiff.driver','values',['fos_forward','fov_forward','fov_forward_all','fos_reverse','fov_reverse','fov_reverse_all']);
			
			//buffer values: 
			checkfield(md,'fieldname','autodiff.obufsize','>=',16);
			checkfield(md,'fieldname','autodiff.lbufsize','>=',16);
			checkfield(md,'fieldname','autodiff.cbufsize','>=',16);
			checkfield(md,'fieldname','autodiff.tbufsize','>=',16);
			checkfield(md,'fieldname','autodiff.gcTriggerRatio','>=',0);
			checkfield(md,'fieldname','autodiff.gcTriggerMaxSize','>=',65536);

			//go through our dependents and independents and check consistency: 
			for (var i=0;i<this.dependents.length;i++){
				dep=this.dependents[i];
				dep.checkconsistency(md,solution,analyses);
			}
			for (var i=0;i<this.independents.length;i++){
				indep=this.independents[i];
				indep.checkconsistency(md,i,solution,analyses,this.driver);
			}
		} // }}}
	//properties 
	// {{{
	this.isautodiff   = false;
	this.dependents   = {};
	this.independents = {};
	this.driver       = 'fos_forward';
	this.obufsize     = NaN;
	this.lbufsize     = NaN;
	this.cbufsize     = NaN;
	this.tbufsize     = NaN;
	this.gcTriggerRatio = NaN;
	this.gcTriggerMaxSize = NaN;

	this.setdefaultparameters();
	//}}}
}
