//GEOMETRY class definition
//
//   Usage:
//      geometry=geometry();

function geometry(){
	//methods 
		this.setdefaultparameters = function (){ //{{{
		}// }}}
		this.disp = function () { //{{{
			console.log(sprintf("   Geometry parameters:"));

			fielddisplay(this,'surface','ice upper surface elevation [m]');
			fielddisplay(this,'thickness','ice thickness [m]');
			fielddisplay(this,'base','ice base elevation [m]');
			fielddisplay(this,'bed','bed elevation [m]');
		} //}}}
		this.checkconsistency = function(md,solution,analyses) { //{{{

			if ((solution==TransientSolutionEnum() & md.transient.isgia) | (solution==GiaSolutionEnum())){
				checkfield(md,'fieldname','geometry.thickness','timeseries',1,'NaN',1,'>=',0);
			}
			else{
				checkfield(md,'fieldname','geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','geometry.base'      ,'NaN',1,'size',[md.mesh.numberofvertices, 1]);
				checkfield(md,'fieldname','geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices, 1],'>',0);
				for(var i=0;i<md.mesh.numberofvertices;i++){
					if (Math.abs(md.geometry.thickness.thickness-md.geometry.surface+md.geometry.base)>Math.pow(10,9)){
						md = checkmessage(md,'equality thickness=surface-base violated');
						break;
					}
				}
				if (solution==TransientSolutionEnum() & md.transient.isgroundingline){
					checkfield(md,'fieldname','geometry.bed','NaN',1,'size',[md.mesh.numberofvertices, 1]);
				}
			}
		} // }}}
	//properties 
	// {{{
		this.surface           = NaN;
		this.thickness         = NaN;
		this.base              = NaN;
		this.bed               = NaN;
		this.hydrostatic_ratio = NaN;
		this.setdefaultparameters();
		//}}}

}
