function plot_manager(md,options,subplotwidth,nlines,ncols,i){
//PLOT__MANAGER - distribute the plots, called by plotmodel
//
//   Usage:
//      plot_manager(md,options,subplotwidth,i);
//
//   See also: PLOTMODEL, PLOT_UNIT
			

	//parse options and get a structure of options. 
	checkplotoptions(md,options);

	//get data to be displayed
	data=options.getfieldvalue('data');

	//standard plot: initialize open Gl for each canvas: 
	var canvas=document.getElementById(options.getfieldvalue('canvasid'));
	//$.("<canvas id='"+options.getfieldvalue('canvasid')+"' width=640 height=480></canvas>)").append("body");

	// Initialize the GL context: 
	var gl=initWebGL(canvas,options);
	if(!gl){
		throw Error("plotmodel error message: could not initialize open Gl!");
	}
	
	//figure out if this is a special plot
	if (typeof data === 'string'){

		switch(data){

			case 'boundaries':
				plot_boundaries(md,options,subplotwidth,i);
				break;
			case 'BC':
				plot_BC(md,options,subplotwidth,i,data);
				break;
			case 'edges':
				plot_edges(md,options,subplotwidth,i,data);
				break;
			case 'elementnumbering':
				plot_elementnumbering(md,options,subplotwidth,i);
				break;
			case 'highlightelements':
				plot_highlightelements(md,options,subplotwidth,i);
				break;
			case 'qmumean':
				plot_qmumean(md,options,nlines,ncols,i);
				break;
			case 'qmustddev':
				plot_qmustddev(md,options,nlines,ncols,i);
				break;
			case 'qmuhistnorm':
				plot_qmuhistnorm(md,options,nlines,ncols,i);
				break;
			case 'qmu_mass_flux_segments':
				plot_qmu_mass_flux_segments(md,options,nlines,ncols,i);
				break;
			case 'part_hist':
				plot_parthist(md,options,nlines,ncols,i);
				break;
			case 'part_hist_n':
				plot_parthistn(md,options,nlines,ncols,i);
				break;
			case 'part_hist_w':
				plot_parthistw(md,options,nlines,ncols,i);
				break;
			case 'elements_type':
				plot_elementstype(md,options,subplotwidth,i);
				break;
			case 'vertexnumbering':
				plot_vertexnumbering(md,options,subplotwidth,i);
				break;
			case 'highlightvertices':
				plot_highlightvertices(md,options,subplotwidth,i);
				break;
			case 'basal_drag':
				plot_basaldrag(md,options,subplotwidth,i,data);
				break;
			case 'basal_dragx':
				plot_basaldrag(md,options,subplotwidth,i,data);
				break;
			case 'basal_dragy':
				plot_basaldrag(md,options,subplotwidth,i,data);
				break;
			case 'driving_stress':
				plot_drivingstress(md,options,subplotwidth,i);
				break;
			case 'mesh':
				//plot_mesh(md,options,nlines,ncols,i);
				plot_mesh(md,options,canvas,gl);
				break;
			case 'none':
				if (!(options.exist('overlay'))){
					plot_none(md,options,nlines,ncols,i);
				}
				break;
			case 'penalties':
				plot_penalties(md,options,subplotwidth,i);
				break;
			case 'partition':
				plot_partition(md,options,nlines,ncols,i);
				break;
			case 'referential':
				plot_referential(md,options,nlines,ncols,i);
				break;
			case 'riftvel':
				plot_riftvel(md,options,nlines,ncols,i);
				break;
			case 'riftnumbering':
				plot_riftnumbering(md,options,nlines,ncols,i);
				break;
			case 'rifts':
				plot_rifts(md,options,nlines,ncols,i);
				break;
			case 'riftrelvel':
				plot_riftrelvel(md,options,nlines,ncols,i);
				break;
			case 'riftpenetration':
				plot_riftpenetration(md,options,nlines,ncols,i);
				break;
			case 'riftfraction':
				plot_riftfraction(md,options,nlines,ncols,i);
				break;
			case 'sarpwr':
				plot_sarpwr(md,options,subplotwidth,i);
				break;
			case 'time_dependant':
				plot_vstime(md,options,nlines,ncols,i);
				break;
			case 'icefront':
				plot_icefront(md,options,subplotwidth,i,data);
				break;
			case 'segments':
				plot_segments(md,options,subplotwidth,i,data);
				break;
			case 'quiver':
				data=[md.initialization.vx, md.initialization.vy]; //Go ahead and try plot_unit

			case 'strainrate_tensor':
			case 'strainrate':
			case 'strainrate_principal':
			case 'strainrate_principalaxis1':
			case 'strainrate_principalaxis2':
			case 'strainrate_principalaxis3':
			case 'stress_tensor':
			case 'stress':
			case 'stress_principal':
			case 'stress_principalaxis1':
			case 'stress_principalaxis2':
			case 'stress_principalaxis3':
			case 'deviatoricstress_tensor':
			case 'deviatoricstress':
			case 'deviatoricstress_principal':
			case 'deviatoricstress_principalaxis1':
			case 'deviatoricstress_principalaxis2':
			case 'deviatoricstress_principalaxis3':
				plot_tensor(md,options,subplotwidth,i,data);
				break;
			case 'thermaltransient_results':
				plot_thermaltransient_results(md,options,subplotwidth,i);
				break;
			case 'transient_movie':
				plot_transient_movie(md,options,subplotwidth,i);
				break;
			case 'transient_results':
				plot_transient_results(md,options,subplotwidth,i);
				break;
			case 'transient_field':
				plot_transient_field(md,options,subplotwidth,i);
				break;
			default:
				if (data in md){
					data=md[data];
				}
				else{
					error('plot error message: data provided not supported yet. Type plotdoc for help');
				}
		}
	}

	//Figure out if this is a semi-transparent plot.
	if (options.exist('overlay')){
		plot_overlay(md,data,options,nlines,ncols,i);
		return;
	}

	//Figure out if this is a semi-transparent plot.
	if (options.exist('googlemaps')){
		plot_googlemaps(md,data,options,nlines,ncols,i);
		return;
	}

	//Figure out if this is a semi-transparent plot.
	if (options.exist('gridded')){
		plot_gridded(md,data,options,nlines,ncols,i);
		return;
	}

	//Figure out if this is a Section plot
	if (options.exist('sectionvalue')){
		plot_section(md,data,options,nlines,ncols,i);
		return;
	}

	//Figure out if this is a Profile plot
	if (options.exist('profile')){
		plot_profile(md,data,options,nlines,ncols,i);
		return;
	}

	if (typeof data !== 'string'){
		//plot unit
		plot_unit(md,data,options,canvas,gl);
	}

	//apply all options
	if (datatype==3){
		options.changefieldvalue('colorbar',2);
		if (options.exist('contourlevels')){
			data2=data;
		}
	}
	//applyoptions(md,data2,options); 
}
