//TRANSIENT class definition
//
//   Usage:
//      transient=new transient();

function transient (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//full analysis: Stressbalance, Masstransport and Thermal but no groundingline migration for now
		this.issmb           = 1;
		this.ismasstransport = 1;
		this.isstressbalance = 1;
		this.isthermal       = 1;
		this.isgroundingline = 0;
		this.isgia           = 0;
		this.isdamageevolution = 0;
		this.islevelset      = 0;
		this.iscalving       = 0;
		this.ishydrology     = 0;

		//default output
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   transient solution parameters:'));

		fielddisplay(this,'issmb','indicates whether a surface mass balance solution is used in the transient');
		fielddisplay(this,'ismasstransport','indicates whether a masstransport solution is used in the transient');
		fielddisplay(this,'isstressbalance','indicates whether a stressbalance solution is used in the transient');
		fielddisplay(this,'isthermal','indicates whether a thermal solution is used in the transient');
		fielddisplay(this,'isgroundingline','indicates whether a groundingline migration is used in the transient');
		fielddisplay(this,'isgia','indicates whether a postglacial rebound model is used in the transient');
		fielddisplay(this,'isdamageevolution','indicates whether damage evolution is used in the transient');
		fielddisplay(this,'islevelset','LEVEL SET DESCRIPTION...');
		fielddisplay(this,'iscalving','indicates whether calving is used in the transient');
		fielddisplay(this,'ishydrology','indicates whether an hydrology model is used');
		fielddisplay(this,'requested_outputs','list of additional outputs requested');


	}// }}}
	//properties 
	// {{{

	this.issmb             = 0;
	this.ismasstransport   = 0;
	this.isstressbalance   = 0;
	this.isthermal         = 0;
	this.isgroundingline   = 0;
	this.isgia             = 0;
	this.isdamageevolution = 0;
	this.islevelset        = 0;
	this.iscalving         = 0;
	this.ishydrology       = 0;
	this.requested_outputs = [];

	this.setdefaultparameters();
	//}}}
}
