//THERMAL class definition
//
//   Usage:
//      thermal=new thermal();

function thermal (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//Number of unstable constraints acceptable
		this.penalty_threshold=0;

		//Type of stabilization used
		this.stabilization=1;

		//Relative tolerance for the enthalpy convergence
		this.reltol=0.01;

		//Maximum number of iterations
		this.maxiter=100;

		//factor used to compute the values of the penalties: kappa=max(stiffness matrix)*10^penalty_factor
		this.penalty_factor=3;

		//Should we use cold ice (default) or enthalpy formulation
		this.isenthalpy=0;

		//will basal boundary conditions be set dynamically
		this.isdynamicbasalspc=0;

		//default output
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   Thermal solution parameters:'));

		fielddisplay(this,'spctemperature','temperature constraints (NaN means no constraint) [K]');
		fielddisplay(this,'stabilization','0: no, 1: artificial_diffusivity, 2: SUPG');
		fielddisplay(this,'reltol','relative tolerance convergence criterion for enthalpy');
		fielddisplay(this,'maxiter','maximum number of non linear iterations');
		fielddisplay(this,'penalty_lock','stabilize unstable thermal constraints that keep zigzagging after n iteration (default is 0, no stabilization)');
		fielddisplay(this,'penalty_threshold','threshold to declare convergence of thermal solution (default is 0)');
		fielddisplay(this,'penalty_factor','scaling exponent (default is 3)');
		fielddisplay(this,'isenthalpy','use an enthalpy formulation to include temperate ice (default is 0)');
		fielddisplay(this,'isdynamicbasalspc',['enable dynamic setting of basal forcing. required for enthalpy formulation (default is 0)']);
		fielddisplay(this,'requested_outputs','additional outputs requested');

	}// }}}
	//properties 
	// {{{

	this.spctemperature    = NaN;
	this.penalty_threshold = 0;
	this.stabilization     = 0;
	this.reltol				= 0;
	this.maxiter           = 0;
	this.penalty_lock      = 0;
	this.penalty_factor    = 0;
	this.isenthalpy        = 0;
	this.isdynamicbasalspc = 0;
	this.requested_outputs = [];

	this.setdefaultparameters();
	//}}}
}
