//INVERSION class definition
//
//   Usage:
//      inversion=new inversion();

function inversion (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//default is incomplete adjoint for now
		this.incomplete_adjoint=1;

		//parameter to be inferred by control methods (only
		//drag and B are supported yet)
		this.control_parameters=['FrictionCoefficient'];

		//number of steps in the control methods
		this.nsteps=20;

		//maximum number of iteration in the optimization algorithm for
		//each step
		this.maxiter_per_step=20*NewArrayFill(this.nsteps,1);

		//the inversed parameter is updated as follows:
		//new_par=old_par + gradient_scaling(n)*C*gradient with C in [0 1];
		//usually the gradient_scaling must be of the order of magnitude of the 
		//inversed parameter (10^8 for B, 50 for drag) and can be decreased
		//after the first iterations
		this.gradient_scaling=NewArrayFill(this.nsteps,50);

		//several responses can be used:
		this.cost_functions=101;

		//step_threshold is used to speed up control method. When
		//misfit(1)/misfit(0) < this.step_threshold, we go directly to
		//the next step
		this.step_threshold=NewArrayFill(this.nsteps,.7); //30 per cent decrement.

		//cost_function_threshold is a criteria to stop the control methods.
		//if J[n]-J[n-1]/J[n] < criteria, the control run stops
		//NaN if not applied
		this.cost_function_threshold=NaN; //not activated

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   inversion parameters:'));
		fielddisplay(this,'iscontrol','is inversion activated?');
		fielddisplay(this,'incomplete_adjoint','1: linear viscosity, 0: non-linear viscosity');
		fielddisplay(this,'control_parameters',"ex: {'FrictionCoefficient'}, or {'MaterialsRheologyBbar'}");
		fielddisplay(this,'nsteps','number of optimization searches');
		fielddisplay(this,'cost_functions','indicate the type of response for each optimization step');
		fielddisplay(this,'cost_functions_coefficients','cost_functions_coefficients applied to the misfit of each vertex and for each control_parameter');
		fielddisplay(this,'cost_function_threshold','misfit convergence criterion. Default is 1%, NaN if not applied');
		fielddisplay(this,'maxiter_per_step','maximum iterations during each optimization step');
		fielddisplay(this,'gradient_scaling','scaling factor on gradient direction during optimization, for each optimization step');
		fielddisplay(this,'step_threshold','decrease threshold for misfit, default is 30%');
		fielddisplay(this,'min_parameters','absolute minimum acceptable value of the inversed parameter on each vertex');
		fielddisplay(this,'max_parameters','absolute maximum acceptable value of the inversed parameter on each vertex');
		fielddisplay(this,'vx_obs','observed velocity x component [m/yr]');
		fielddisplay(this,'vy_obs','observed velocity y component [m/yr]');
		fielddisplay(this,'vel_obs','observed velocity magnitude [m/yr]');
		fielddisplay(this,'thickness_obs','observed thickness [m]');
		fielddisplay(this,'surface_obs','observed surface elevation [m]');
		console.log('Available cost functions:');
		console.log('   101: SurfaceAbsVelMisfit');
		console.log('   102: SurfaceRelVelMisfit');
		console.log('   103: SurfaceLogVelMisfit');
		console.log('   104: SurfaceLogVxVyMisfit');
		console.log('   105: SurfaceAverageVelMisfit');
		console.log('   201: ThicknessAbsMisfit');
		console.log('   501: DragCoefficientAbsGradient');
		console.log('   502: RheologyBbarAbsGradient');
		console.log('   503: ThicknessAbsGradient');

	}// }}}
	//properties 
	// {{{

	this.iscontrol                   = 0;
	this.incomplete_adjoint          = 0;
	this.control_parameters          = NaN;
	this.nsteps                      = 0;
	this.maxiter_per_step            = NaN;
	this.cost_functions              = NaN;
	this.cost_functions_coefficients = NaN;
	this.gradient_scaling            = NaN;
	this.cost_function_threshold     = 0;
	this.min_parameters              = NaN;
	this.max_parameters              = NaN;
	this.step_threshold              = NaN;
	this.vx_obs                      = NaN;
	this.vy_obs                      = NaN;
	this.vz_obs                      = NaN;
	this.vel_obs                     = NaN;
	this.thickness_obs               = NaN;
	this.surface_obs                 = NaN;

	this.setdefaultparameters();
	//}}}
}
