//AUTODIFF class definition
//
//   Usage:
//      autodiff=new autodiff();

function autodiff (){
	//methods
	this.setdefaultparameters = function(){// {{{

		this.obufsize     = 524288;
		this.lbufsize     = 524288;
		this.cbufsize     = 524288;
		this.tbufsize     = 524288;
		this.gcTriggerRatio=2.0;
		this.gcTriggerMaxSize=65536;

	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   automatic differentiation parameters:'));
		fielddisplay(this,'isautodiff','indicates if the automatic differentiation is activated');
		fielddisplay(this,'dependents','list of dependent variables');
		fielddisplay(this,'independents','list of independent variables');
		fielddisplay(this,'driver',"ADOLC driver ('fos_forward' or 'fov_forward')");
		fielddisplay(this,'obufsize','Number of operations per buffer (==OBUFSIZE in usrparms.h)');
		fielddisplay(this,'lbufsize','Number of locations per buffer (==LBUFSIZE in usrparms.h)');
		fielddisplay(this,'cbufsize','Number of values per buffer (==CBUFSIZE in usrparms.h)');
		fielddisplay(this,'tbufsize','Number of taylors per buffer (<=TBUFSIZE in usrparms.h)');
		fielddisplay(this,'gcTriggerRatio','free location block sorting/consolidation triggered if the ratio between allocated and used locations exceeds gcTriggerRatio');
		fielddisplay(this,'gcTriggerMaxSize','free location block sorting/consolidation triggered if the allocated locations exceed gcTriggerMaxSize');

	}// }}}
	//properties 
	// {{{
	this.isautodiff   = false;
	this.dependents   = {};
	this.independents = {};
	this.driver       = 'fos_forward';
	this.obufsize     = NaN;
	this.lbufsize     = NaN;
	this.cbufsize     = NaN;
	this.tbufsize     = NaN;
	this.gcTriggerRatio = NaN;
	this.gcTriggerMaxSize = NaN;

	this.setdefaultparameters();
	//}}}
}
