//TOOLKITS class definition
//
//   Usage:
//      toolkits=new toolkits();

function toolkits (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//default toolkits: 
		if (IssmConfig('_HAVE_PETSC_')){
			//MUMPS is the default toolkits
			if (IssmConfig('_HAVE_MUMPS_')){
				this.DefaultAnalysis           = mumpsoptions();
			}
			else{
				this.DefaultAnalysis           = iluasmoptions(); 
			}
		}
		else{
			if (IssmConfig('_HAVE_MUMPS_')){
				this.DefaultAnalysis           = issmmumpssolver(); 
			}
			else if (IssmConfig('_HAVE_GSL_')){
				this.DefaultAnalysis           = issmgslsolver(); 
			}
			else{
				console.warn('toolkits setdefaultparameters message: need at least Mumps or Gsl to define an issm solver type, no default solver assigned');
			}
		}
	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('List of toolkits options per analysis:\n'));
		for(var prop in this){
			if(typeof this[prop] == 'object'){
				console.log(prop+ ':',this[prop]);
			}
		}
	}// }}}
	//properties 
	// {{{
	this.DefaultAnalysis           = [];
	//The other properties are dynamic
	this.setdefaultparameters();
	//}}}
}
