//FLOWEQUATION class definition
//
//   Usage:
//      flowequation=new flowequation();

function flowequation (){
	//methods
	this.setdefaultparameters = function(){// {{{
		//P1 for SSA
		this.fe_SSA= 'P1';

		//P1 for HO
		this.fe_HO= 'P1';

		//MINI condensed element for FS by default
		this.fe_FS = 'MINIcondensed';
	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   flow equation parameters:'));

		fielddisplay(this,'isSIA','is the Shallow Ice Approximation (SIA) used ?');
		fielddisplay(this,'isSSA','is the Shelfy-Stream Approximation (SSA) used ?');
		fielddisplay(this,'isL1L2','is the L1L2 approximation used ?');
		fielddisplay(this,'isHO','is the Higher-Order (HO) approximation used ?');
		fielddisplay(this,'isFS','are the Full-FS (FS) equations used ?');
		fielddisplay(this,'fe_SSA',"Finite Element for SSA  'P1', 'P1bubble' 'P1bubblecondensed' 'P2'");
		fielddisplay(this,'fe_HO', "Finite Element for HO   'P1' 'P1bubble' 'P1bubblecondensed' 'P1xP2' 'P2xP1' 'P2'");
		fielddisplay(this,'fe_FS', "Finite Element for FS   'P1P1' (debugging only) 'P1P1GLS' 'MINIcondensed' 'MINI' 'TaylorHood' 'XTaylorHood'");
		fielddisplay(this,'vertex_equation','flow equation for each vertex');
		fielddisplay(this,'element_equation','flow equation for each element');
		fielddisplay(this,'borderSSA',"vertices on SSA's border (for tiling)");
		fielddisplay(this,'borderHO',"vertices on HO's border (for tiling)");
		fielddisplay(this,'borderFS',"vertices on FS' border (for tiling)");

	}// }}}
	//properties 
	// {{{
	this.isSIA                          = 0;
	this.isSSA                          = 0;
	this.isL1L2                         = 0;
	this.isHO                           = 0;
	this.isFS                           = 0;
	this.fe_SSA                         = '';
	this.fe_HO                          = '';
	this.fe_FS                          = '';
	this.augmented_lagrangian_r         = 1.;
	this.augmented_lagrangian_rhop      = 1.;
	this.augmented_lagrangian_rlambda   = 1.;
	this.augmented_lagrangian_rholambda = 1.;
	this.XTH_theta                      = 0.;
	this.vertex_equation                = NaN;
	this.element_equation               = NaN;
	this.borderSSA                      = NaN;
	this.borderHO                       = NaN;
	this.borderFS                       = NaN;
	this.setdefaultparameters();
	//}}}
}
