function ArrayMax(array){ //{{{
	return Math.max.apply(null,array);
} //}}}
function ArrayMax2D(array){ //{{{
	
	var max=0;

	for (i=0;i<array.length;i++){
		var subarray=array[i];
		max=Math.max(max,ArrayMax(subarray));
	}

	return max;
} //}}}
function ArrayMin(array){ //{{{
	return Math.min.apply(null,array);
} //}}}
function ArraySum(array){ //{{{
	var sum=0;
	for(var i=0;i<array.length;i++)sum+=array[i];
	return sum;
} //}}}
function ArrayMin2D(array){ //{{{
	
	var min=ArrayMax2D(array);

	for (i=0;i<array.length;i++){
		var subarray=array[i];
		min=Math.min(min,ArrayMin(subarray));
	}

	return min;
} //}}}
function ListToMatrix(list, elementsPerSubArray) { //{{{
	var matrix = [], i, k;

	for (i = 0, k = -1; i < list.length; i++) {
		if (i % elementsPerSubArray === 0) {
			k++;
			matrix[k] = [];
		}

		matrix[k].push(list[i]);
	}

	return matrix;
} //}}}
function MatrixToList(matrix) { //{{{
	
	var width = matrix[0].length;
	var length = matrix.length;
	var list= new Array(width*length);

	for(var i=0;i<length;i++){
		for(var j=0;j<width;j++){
			list[i*width+j]=matrix[i][j];
		}
	}
		
	return list;
} //}}}
function IsArray(object) { //{{{

	if( Object.prototype.toString.call( object ) === '[object Array]' ) {
		return 1;
	}
	else return 0;

} //}}}
function ArrayNot(array) { //{{{

	var notarray=array;
	for (i=0;i<array.length;i++)notarray[i]=-array[i];
	return notarray;
} //}}}
function ArrayPow(array,coefficient) { //{{{

	var powarray=array;
	for (i=0;i<array.length;i++)powarray[i]=Math.pow(array[i],coefficient);
	return powarray;
} //}}}
function ArraySqrt(array) { //{{{

	var sqrtarray=array;
	for (i=0;i<array.length;i++)sqrtarray[i]=Math.sqrt(array[i]);
	return sqrtarray;
} //}}}
function ArrayMag(array1,array2) { //{{{

	var arraymag=NewArrayFill(array1.length,0);
	for (var i=0;i<array1.length;i++)arraymag[i]=Math.sqrt(Math.pow(array1[i],2)+Math.pow(array2[i],2));
	return arraymag;
} //}}}
function ArrayAnyNaN(array) { //{{{

	for(var i=0;i<array.length;i++){
		if (isNaN(array[i])) return 1;
	}
	return 0;
} //}}}
function ArrayAnyBelowOrEqual(array,value) { //{{{

	for(var i=0;i<array.length;i++){
		if (array[i]<=value)return 1;
	}
	return 0;
} //}}}
function ArrayAnyBelowStrict(array,value) { //{{{

	for(var i=0;i<array.length;i++){
		if (array[i]<value)return 1;
	}
	return 0;
} //}}}
function ArrayAnd(array1,array2) { //{{{

	var array=array1;
	for (i=0;i<array1.length;i++)array[i]=array1[i] & array2[i];
	return array;
} //}}}
function NewArrayFill(size,value) { //{{{

	return new Array(size).fill(value);
} //}}}
function ArrayFind(array,value) { //{{{
	
	//find number of indices
	var count=0;
	for (i=0;i<array.length;i++)if(array[i]==value)count++;

	//allocate:
	var indices= NewArrayFill(count,0);

	//fill in:
	count=0;
	for (i=0;i<array.length;i++){
		if(array[i]==value){
			indices[count]=i;
			count++;
		}
	}
	return indices;
} //}}}
function ArrayFindNot(array,value) { //{{{
	
	//find number of indices
	var count=0;
	for (i=0;i<array.length;i++)if(array[i]!=value)count++;

	//allocate:
	var indices= NewArrayFill(count,0);

	//fill in:
	count=0;
	for (i=0;i<array.length;i++){
		if(array[i]!=value){
			indices[count]=i;
			count++;
		}
	}
	return indices;
} //}}}
function Create2DArray(rows,cols) { //{{{
	var arr = [];

	for (var i=0;i<rows;i++) {
		arr[i] = new Array(cols);
	}

	return arr;
} //}}}
