//TIMESTEPPING class definition
//
//   Usage:
//      timestepping=new timestepping();

function timestepping (){
	//methods
	this.setdefaultparameters = function(){// {{{
		//time between 2 time steps
		this.time_step=1./2.;

		//final time
		this.final_time=10.*this.time_step;

		//time adaptation? 
		this.time_adapt=0;
		this.cfl_coefficient=0.5;

		//should we interpolate forcings between timesteps?
		this.interp_forcings=1;

		//In years by default
		this.in_years = 1;

	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   timestepping parameters:'));

		if(this.in_years) unit = 'yr';
		else unit = 's';
		fielddisplay(this,'start_time','simulation starting time ['+ unit + ']');
		fielddisplay(this,'final_time','final time to stop the simulation ['+ unit + ']');
		fielddisplay(this,'time_step','length of time steps [' +unit+ ']');
		fielddisplay(this,'time_adapt','use cfl condition to define time step ? (0 or 1) ');
		fielddisplay(this,'cfl_coefficient','coefficient applied to cfl condition');
		fielddisplay(this,'interp_forcings','interpolate in time between requested forcing values ? (0 or 1)');
		fielddisplay(this,'in_years','time unit, 1: years, 0: seconds');


	}// }}}
	//properties 
	// {{{
	this.start_time      = 0.;
	this.final_time      = 0.;
	this.time_step       = 0.;
	this.time_adapt      = 0;
	this.cfl_coefficient = 0.;
	this.interp_forcings = 1;
	this.in_years        = 1;

	this.setdefaultparameters();
	//}}}
}
