//STRESSBALANCE class definition
//
//   Usage:
//      stressbalance=new stressbalance();

function stressbalance (){
	//methods
	this.setdefaultparameters = function(){// {{{

		//maximum of non-linear iterations.
		this.maxiter=100;

		//Convergence criterion: absolute, relative and residual
		this.restol=Math.pow(10,-4); 
		this.reltol=0.01;
		this.abstol=10;

		this.FSreconditioning=Math.pow(10,13);
		this.shelf_dampening=0;

		//Penalty factor applied kappa=max(stiffness matrix)*10^penalty_factor
		this.penalty_factor=3;

		//coefficient to update the viscosity between each iteration of
		//a stressbalance according to the following formula
		//viscosity(n)=viscosity(n)+viscosity_overshoot(viscosity(n)-viscosity(n-1))
		this.viscosity_overshoot=0;

		//Stop the iterations of rift if below a threshold
		this.rift_penalty_threshold=0;

		//in some solutions, it might be needed to stop a run when only
		//a few constraints remain unstable. For thermal computation, this
		//parameter is often used.
		this.rift_penalty_lock=10;

		//output default:
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   StressBalance solution parameters:'));

		console.log(sprintf('\n      %s','Convergence criteria:'));
		fielddisplay(this,'restol','mechanical equilibrium residual convergence criterion');
		fielddisplay(this,'reltol','velocity relative convergence criterion, NaN: not applied');
		fielddisplay(this,'abstol','velocity absolute convergence criterion, NaN: not applied');
		fielddisplay(this,'isnewton',"0: Picard's fixed point, 1: Newton's method, 2: hybrid");
		fielddisplay(this,'maxiter','maximum number of nonlinear iterations');
		fielddisplay(this,'viscosity_overshoot','over-shooting constant new=new+C*(new-old)');

		console.log(sprintf('\n      %s','boundary conditions:'));
		fielddisplay(this,'spcvx','x-axis velocity constraint (NaN means no constraint) [m/yr]');
		fielddisplay(this,'spcvy','y-axis velocity constraint (NaN means no constraint) [m/yr]');
		fielddisplay(this,'spcvz','z-axis velocity constraint (NaN means no constraint) [m/yr]');

		console.log(sprintf('\n      %s','Rift options:'));
		fielddisplay(this,'rift_penalty_threshold','threshold for instability of mechanical constraints');
		fielddisplay(this,'rift_penalty_lock','number of iterations before rift penalties are locked');

		console.log(sprintf('\n      %s','Penalty options:'));
		fielddisplay(this,'penalty_factor','offset used by penalties: penalty = Kmax*10^offset');
		fielddisplay(this,'vertex_pairing','pairs of vertices that are penalized');

		console.log(sprintf('\n      %s','Other:'));
		fielddisplay(this,'shelf_dampening','use dampening for floating ice ? Only for FS model');
		fielddisplay(this,'FSreconditioning','multiplier for incompressibility equation. Only for FS model');
		fielddisplay(this,'referential','local referential');
		fielddisplay(this,'loadingforce','loading force applied on each point [N/m^3]');
		fielddisplay(this,'requested_outputs','additional outputs requested');



	}// }}}
	//properties 
	// {{{
	this.spcvx                  = NaN;
	this.spcvy                  = NaN;
	this.spcvz                  = NaN;
	this.restol                 = 0;
	this.reltol                 = 0;
	this.abstol                 = 0;
	this.isnewton               = 0;
	this.FSreconditioning       = 0;
	this.viscosity_overshoot    = 0;
	this.maxiter                = 0;
	this.shelf_dampening        = 0;
	this.vertex_pairing         = NaN;
	this.penalty_factor         = NaN;
	this.rift_penalty_lock      = NaN;
	this.rift_penalty_threshold = 0;
	this.referential            = NaN;
	this.loadingforce           = NaN;
	this.requested_outputs      = ['']
	this.setdefaultparameters();
	//}}}
}
