//DAMAGE class definition
//
//   Usage:
//      damage=new damage();

function damage (){
	//methods
	this.setdefaultparameters = function(){// {{{
		
		//damage parameters: 
		this.isdamage=0;
		this.D=0;
		this.law=0;

		this.max_damage=1-1e-5; //if damage reaches 1, solve becomes singular, as viscosity becomes nil

		//Type of stabilization used
		this.stabilization=4;

		//Maximum number of iterations
		this.maxiter=100;

		//finite element interpolation
		this.elementinterp='P1';

		//damage evolution parameters 
		this.stress_threshold=1.3e5;
		this.kappa=2.8;
		this.healing=0;
		this.c1=0;
		this.c2=0;
		this.c3=0;
		this.c4=0;
		this.equiv_stress=0;

		//output default:
		this.requested_outputs=['default'];

	}// }}}
	this.disp= function(){// {{{
		console.log(sprintf('   Damage:\n'));

		fielddisplay(this,'isdamage','is damage mechanics being used? {true,false}');
		if (this.isdamage){
			fielddisplay(this,'law',"damage law ['0: analytical','1: pralong']");
			fielddisplay(this,'D','damage tensor (scalar)');
			fielddisplay(this,'spcdamage','damage constraints (NaN means no constraint)');
			fielddisplay(this,'max_damage','maximum possible damage (0<=max_damage<1)');

			fielddisplay(this,'stabilization','0: no, 1: artificial_diffusivity, 2: SUPG (not working), 4: flux corrected transport');
			fielddisplay(this,'maxiter','maximum number of non linear iterations');
			fielddisplay(this,'elementinterp',"interpolation scheme for finite elements {'P1','P2'}");
			fielddisplay(this,'stress_threshold','stress threshold for damage initiation [Pa]');
			fielddisplay(this,'kappa','ductility parameter for stress softening and damage');
			fielddisplay(this,'c1','damage parameter 1');
			fielddisplay(this,'c2','damage parameter 2');
			fielddisplay(this,'c3','damage parameter 3');
			fielddisplay(this,'c4','damage parameter 4');
			fielddisplay(this,'healing','damage healing parameter');
			fielddisplay(this,'equiv_stress','0: von Mises, 1: max principal');
			fielddisplay(this,'requested_outputs','additional outputs requested');
		}
	}// }}}
	//properties 
	// {{{
	this.isdamage            = 0;
	this.D                   = NaN;
	this.law                 = 0;
	this.spcdamage           = NaN; 
	this.max_damage          = 0;

	//numerical
	this.stabilization       = 0;
	this.maxiter             = 0;
	this.elementinterp       = '';

	//general parameters for evolution law: 
	this.stress_threshold    = 0;
	this.kappa               = 0;
	this.c1                  = 0;
	this.c2                  = 0;
	this.c3                  = 0;
	this.c4                  = 0;
	this.healing             = 0;
	this.equiv_stress		  = 0;
	this.requested_outputs   = [''];

	this.setdefaultparameters();
	//}}}
}
