function plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options) {
	//PLOT_UNIT - unit plot, display data
	//
	//   Usage:
	//      plot_unit(x,y,z,elements,data,is2d,isplanet,datatype,options);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//edgecolor
	edgecolor=options.getfieldvalue('edgecolor','none');
	
	/*First initialize webgl for the corresponding canvas: */
	var canvas=document.getElementById(options.getfieldvalue('canvasid'));

	// Initialize the GL context: 
	var gl=initWebGL(canvas,options);

	// Only continue if WebGL is available and working
	if (gl) {
		loadShaders(gl);
		var node=loadModel(gl,x,y,z,elements,data);
		draw(gl,canvas,node);
	}

	switch(datatype){

		//element plot
		case 1:

			pos=ArrayFindNot(data,NaN); //needed for element on water
			if (elements[0].length==6){ //prisms

				/*A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); D=elements(pos,4); E=elements(pos,5); F=elements(pos,6);
				  patch( 'Faces', [A B C],  'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [D E F],  'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [A B E D],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [B E F C],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces', [C A D F],'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  */
			}
			else if (elements[0].length==4){ //tetras
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4);
				  patch( 'Faces',[A B C],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[A B D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[B C D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);
				  patch( 'Faces',[C A D],'Vertices', [x y z],'CData',data(pos),'FaceColor','flat','EdgeColor',edgecolor);*/
			}
			else{
				/*A=elements(pos,1); B=elements(pos,2); C=elements(pos,3);
				  patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);*/
			}
			break;

			//node plot
		case 2:

			if (elements[0].length==6){ //prisms
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
				  patch( 'Faces', [A B C],  'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [D E F],  'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [A B E D],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [B E F C],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces', [C A D F],'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);*/
			}
			else if (elements[0].length==4){//tetras
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4);
				  patch( 'Faces',[A B C],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[A B D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[B C D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  patch( 'Faces',[C A D],'Vertices', [x y z],'FaceVertexCData',data(:),'FaceColor','interp','EdgeColor',edgecolor);*/
			}
			else{
				
				/*A=elements(:,1); B=elements(:,2); C=elements(:,3); 
				  patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
				  */
			}
			break;

			//quiver plot
		case 3:

			if (is2d){
				//plot_quiver(x,y,data(:,1),data(:,2),options);
			}
			else{
				//plot_quiver3(x,y,z,data(:,1),data(:,2),data(:,3),options);
			}

		default:
				throw Error(sprintf("%s%i%s\n",'case ',datatype,' not supported'));
	}
}
