function J =objectivefunctionC(search_scalar,models,inputs,p_g,grad_g,n,analysis_type,sub_analysis_type);

%recover active model.
m=models.active;

%recover some parameters
optscal=m.parameters.optscal(n);
fit=m.parameters.fit(n);
control_type=m.parameters.control_type;
dt=m.parameters.dt;

%Update along gradient using scalar supplied by fmincon optimization routine
parameter=p_g+search_scalar*optscal*grad_g;

%Plug parameter into inputs
inputs=add(inputs,m.parameters.control_type,parameter,'doublevec',1,m.parameters.numberofnodes);

%Run diagnostic with updated parameters.
if dt==0, 
	%do a simple diagnostic, with the current temperature profile, do not look for steady state.
	u_g=diagnostic_core_nonlinear(m,inputs,analysis_type,sub_analysis_type);
else
	%do a full thermal mechanical steady state converged computation, much slower!
	results=steadystate_core(models,inputs); u_g=results.u_g; 

	%u_g ships with 3 or 4 dofs, we only want the horizontal ones!
	if ~models.dh.parameters.isstokes, 
		u_g=u_g(dofsetgen([1,2],3,m.parameters.numberofnodes*3));
	end
end

%add velocity to inputs.
inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);

%Compute misfit for this velocity field. 
J=Misfit(m.elements,m.nodes,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
