//CONSTANTS class definition
//
//   Usage:
//      constants=constants();

function constants() {
	//methods 
		this.setdefaultparameters = function (){ //{{{

			//acceleration due to gravity (m/s^2)
			this.g=9.81;

			//Earth's rotation speed 
			this.omega = 7.292*1e-5;

			//converstion from year to seconds
			this.yts=365*24*3600;

			//the reference temperature for enthalpy model (cf Aschwanden)
			this.referencetemperature=223.15;
		}// }}}
		this.disp = function () { //{{{
			console.log(sprintf("   Constants parameters:")); 
			
			fielddisplay(this,'g','gravitational acceleration [m/s^2]');
			fielddisplay(this,'omega','angular velocity of Earth [rad/s]');
			fielddisplay(this,'yts','number of seconds in a year [s/yr]');
			fielddisplay(this,'referencetemperature','reference temperature used in the enthalpy model [K]');

		} //}}}
	//properties 
	// {{{
		this.g                    = 0.;
		this.omega                = 0.;
		this.yts                  = 0.;
		this.referencetemperature = 0.;
		this.setdefaultparameters();
		//}}}
}
