function parameterize(md){

	//Geometry
	var hmin=300;
	var hmax=1000;
	var ymin=ArrayMin(md.mesh.y);
	var ymax=ArrayMax(md.mesh.y);
	var xmin=ArrayMin(md.mesh.x);
	var xmax=ArrayMax(md.mesh.x);
	
	md.geometry.thickness=NewArrayFill(md.mesh.numberofvertices,0);
	md.geometry.base=NewArrayFill(md.mesh.numberofvertices,0);
	md.geometry.surface=NewArrayFill(md.mesh.numberofvertices,0);
	md.geometry.bed=NewArrayFill(md.mesh.numberofvertices,0);

	for(i=0;i<md.mesh.numberofvertices;i++){
		md.geometry.thickness[i]=hmax+(hmin-hmax)*(md.mesh.y[i]-ymin)/(ymax-ymin)+0.1*(hmin-hmax)*(md.mesh.x[i]-xmin)/(xmax-xmin);
		md.geometry.base[i]=-md.materials.rho_ice/md.materials.rho_water*md.geometry.thickness[i];
		md.geometry.surface[i]=md.geometry.base[i]+md.geometry.thickness[i];
	}
	
	//Initial velocity 
	x     = transpose(ncread('../Data/SquareShelfConstrained.nc','x'));
	y     = transpose(ncread('../Data/SquareShelfConstrained.nc','y'));
	vx    = transpose(ncread('../Data/SquareShelfConstrained.nc','vx'));
	vy    = transpose(ncread('../Data/SquareShelfConstrained.nc','vy'));
	index = transpose(ncread('../Data/SquareShelfConstrained.nc','index'));
	md.initialization.vx=InterpFromMeshToMesh2d(index,x,y,vx,md.mesh.x,md.mesh.y);
	md.initialization.vy=InterpFromMeshToMesh2d(index,x,y,vy,md.mesh.x,md.mesh.y);
	clear vx vy x y index;
	md.initialization.vz=zeros(md.mesh.numberofvertices,1);
	md.initialization.pressure=zeros(md.mesh.numberofvertices,1);

	//Materials
	md.initialization.temperature=(273-20)*ones(md.mesh.numberofvertices,1);
	md.materials.rheology_B=paterson(md.initialization.temperature);
	md.materials.rheology_n=3*ones(md.mesh.numberofelements,1);

	//Surface mass balance and basal melting
	md.smb.mass_balance=10*ones(md.mesh.numberofvertices,1);
	md.basalforcings.floatingice_melting_rate=5*ones(md.mesh.numberofvertices,1);
	md.basalforcings.groundedice_melting_rate=5*ones(md.mesh.numberofvertices,1);

	//Friction
	md.friction.coefficient=20*ones(md.mesh.numberofvertices,1);
	md.friction.coefficient(find(md.mask.groundedice_levelset<0.))=0.;
	md.friction.p=ones(md.mesh.numberofelements,1);
	md.friction.q=ones(md.mesh.numberofelements,1);

	//Numerical parameters
	md.stressbalance.viscosity_overshoot=0.0;
	md.masstransport.stabilization=1;
	md.thermal.stabilization=1;
	md.verbose=verbose(0);
	md.settings.waitonlock=30;
	md.stressbalance.restol=0.05;
	md.stressbalance.reltol=0.05;
	md.steadystate.reltol=0.05;
	md.stressbalance.abstol=NaN;
	md.timestepping.time_step=1;
	md.timestepping.final_time=3;

	//Deal with boundary conditions:
	md=SetIceShelfBC(md);

	//Change name so that no tests have the same name
	A=dbstack;
	if (length(A)>2), md.miscellaneous.name=A(3).file(1:end-2); end

}
