%FRICTIONCOULOMB class definition
%
%   Usage:
%      frictioncoulomb=frictioncoulomb();

classdef frictioncoulomb
	properties (SetAccess=public) 
		coefficient        = NaN;
		p                  = NaN;
		q                  = NaN;
		coefficientcoulomb = NaN;
	end
	methods
		function createxml(self,fid) % {{{
			fprintf(fid, '\n\n');
			fprintf(fid, '%s\n', '<!-- Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p -->');
			fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p">','<section name="frictioncoulomb" />');   
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="coefficient" type="',   	class(self.coefficient),'" default="',     	convert2str(self.coefficient),'">',              '     <section name="frictioncoulomb" />','     <help> friction coefficient [SI] </help>','</parameter>');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="p" type="',               class(self.p),'" default="',                 convert2str(self.p),'">',   '     <section name="frictioncoulomb" />','     <help> p exponent </help>','</parameter>');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n',        '<parameter key ="q" type="',               class(self.q),'" default="',                 convert2str(self.q),'">',            '     <section name="frictioncoulomb" />','     <help> q exponent </help>','</parameter>');
			fprintf(fid,'%s\n%s\n','</frame>');
		end % }}}
		function self = extrude(self,md) % {{{
			self.coefficient=project3d(md,'vector',self.coefficient,'type','node','layer',1);
			self.coefficientcoulomb=project3d(md,'vector',self.coefficientcoulomb,'type','node','layer',1);
			self.p=project3d(md,'vector',self.p,'type','element');
			self.q=project3d(md,'vector',self.q,'type','element');
		end % }}}
		function self = frictioncoulomb(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{

		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end
			md = checkfield(md,'fieldname','friction.coefficient','timeseries',1,'NaN',1);
			md = checkfield(md,'fieldname','friction.coefficientcoulomb','timeseries',1,'NaN',1);
			md = checkfield(md,'fieldname','friction.q','NaN',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','friction.p','NaN',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(self) % {{{
			disp(sprintf('Basal shear stress parameters: Sigma_b = min( coefficient^2 * Neff ^r * |u_b|^(s-1) * u_b\n, coefficientcoulomb^2 * rho_i * g * (h-h_f)) (effective stress Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p, floatation thickness h_f=max(0,-rho_sw / rho_i * bed))'));
			fielddisplay(self,'coefficient','power law (Weertman) friction coefficient [SI]');
			fielddisplay(self,'coefficientcoulomb','Coulomb friction coefficient [SI]');
			fielddisplay(self,'p','p exponent');
			fielddisplay(self,'q','q exponent');
		end % }}}
		function marshall(self,md,fid) % {{{

			WriteData(fid,'enum',FrictionLawEnum,'data',7,'format','Integer');
			WriteData(fid,'object',self,'fieldname','coefficient','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'enum',FrictionCoefficientEnum());
			WriteData(fid,'object',self,'fieldname','coefficientcoulomb','format','DoubleMat','mattype',1,'enum',FrictionCoefficientcoulombEnum());
			WriteData(fid,'object',self,'fieldname','p','format','DoubleMat','mattype',2,'enum',FrictionPEnum());
			WriteData(fid,'object',self,'fieldname','q','format','DoubleMat','mattype',2,'enum',FrictionQEnum());

		end % }}}
	end
end
