/*\file FetchData.cpp:
 * \brief: general I/O interface to fetch data in javascript
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./javascriptio.h"
#include <cstring> 

/*Primitive data types*/
/*FUNCTION FetchData(double* pscalar,double scalar){{{*/
void FetchData(double* pscalar,double scalar){
	
	*pscalar = scalar;
}
/*}}}*/

/*ISSM objects*/
/*FUNCTION FetchData(Contours** pcontours,double* x, double* y, int nods){{{*/
void FetchData(Contours** pcontours,double* x, double* y, int nods){

	int             numcontours,index,test1,test2;
	char            *contourname = NULL;
	Contours        *contours    = NULL;
	Contour<double> *contouri    = NULL;

	/*only 1 contour for now: */
	contours=new Contours();

	if (nods){
			
		contouri=new Contour<double>();
		contouri->nods=nods;
		contouri->x=xNew<IssmPDouble>(nods); xMemCpy<IssmPDouble>(contouri->x,x,nods);
		contouri->y=xNew<IssmPDouble>(nods); xMemCpy<IssmPDouble>(contouri->y,y,nods);

		contours->AddObject(contouri);
	}
	
	*pcontours=contours;
}
/*}}}*/
