function triangle(md,domain, rifts, resolution){
//TRIANGLE - create model mesh using the triangle package
//
//   This routine creates a model mesh using TriMesh and a domain outline, to within a certain resolution
//   where md is a @model object, domainname is the name of an Argus domain outline file, 
//   and resolution is a characteristic length for the mesh (same unit as the domain outline
//   unit). Riftname is an optional argument (Argus domain outline) describing rifts.
//
//   Usage:
//      triangle(md,domain,resolution)
//   or triangle(md,domain,riftname, resolution)
//
//   Examples:
//      triangle(md,domain,1000);
//      triangle(md,domain, rifts, 1500);

	var area=Math.pow(resolution,2);

	//Call mesher: 
	var array = TriMesh(md, domain, rifts, area); 

	//Fill in rest of fields:
	//md.mesh.vertexonboundary=zeros(md.mesh.numberofvertices,1); md.mesh.vertexonboundary(md.mesh.segments(:,1:2))=1;

	//Now, build the connectivity tables for this mesh.
	//md.mesh.vertexconnectivity=NodeConnectivity(md.mesh.elements,md.mesh.numberofvertices);
	//md.mesh.elementconnectivity=ElementConnectivity(md.mesh.elements,md.mesh.vertexconnectivity);

}
