function plot_section(md,data,options_structure,width,i)
%PLOT_SECTION - plot a given field on a section
%
%   Usage:
%      plot_section(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%How many subplots?
if ~isnan(options_structure.showsection)

	%Compute the indexes of the 2 plots (one for the sectionvalue and one for showsection
	upperplots=fix((i-1)/width);
	if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
	index1=4*width*upperplots+2*leftplots+1;
	index2=index1+1;
	width=2*width;
else
	index1=i;
end

%process data and model
[x_m y_m z_m elements_m is2d]=processmesh(md,options_structure);
[data isongrid isquiver]=processdata(md,data,options_structure);

%replug x and y onto model so that SectionValue treats the problem correctly
if ~isnan(options_structure.layer)
	md.x=md.x2d; md.y=md.y2d; md.elements=md.elements2d; md.type='2d';
end

%resolution
if ~isnan(options_structure.resolution),
	resolution=options_structure.resolution;
else %Default resolution
	resolution=[1000 10*md.numlayers];
	disp(['plot_section warning: no resolution specified, use default resolution: [horizontal_resolution vertical_resolution]=[' num2str(resolution)  ']']);
end

%Compute section value
[elements,x,y,z,s,data_s]=SectionValues(md,data,options_structure.sectionvalue,resolution);

if is2d

	%Show Section if requested by user
	if ~isnan(options_structure.showsection)

		%compute number of labels
		numlabels=min(options_structure.showsection,length(s));
		shift=fix(length(s)/numlabels);

		%plot labels on current graph
		hold on
		text(s(1),data_s(1),'1','backgroundcolor',[0.8 0.9 0.8])
		for i=2:numlabels-1
			text(s(1+(i-1)*shift),data_s(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
		end
		text(s(end),data_s(end),'end','backgroundcolor',[0.8 0.9 0.8])

		%plot section only with labels
		subplot(width,width,index2)
		plot_unit(x_m,y_m,z_m,elements_m,data,isongrid,is2d,isquiver,options_structure)
		hold on
		text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
		for i=2:numlabels-1
			text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
		end
		text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
		plot(x,y,'-r')
		axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
		view(2)
	end

	%plot section value
	subplot(width,width,index1)
	plot(s,data_s)

else
	%plot section value
	%if user requested view2: 2d plot with curvilinear coordinate
	if (~isnan(options_structure.view) & options_structure.view==2 )

		%Show Section if requested by user
		if ~isnan(options_structure.showsection)

			%compute number of labels
			numlabels=min(options_structure.showsection,length(s));
			shift=fix(length(s)/numlabels);

			%plot labels on current graph
			hold on
			text(s(1),z(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(s(1+(i-1)*shift),z(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(s(end),z(end),'end','backgroundcolor',[0.8 0.9 0.8])

			%plot section only with labels
			subplot(width,width,index2)
			plot_unit(x_m,y_m,z_m,elements_m,data,isongrid,is2d,isquiver,options_structure)
			hold on
			text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
			plot(x,y,'-r')
			axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
			view(2)
		end

		subplot(width,width,index1)
		A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
		patch( 'Faces', [A B C D], 'Vertices', [s z zeros(length(s),1)],'FaceVertexCData',data_s,'FaceColor','interp','EdgeColor','none');

	else

		%Show Section if requested by user
		if ~isnan(options_structure.showsection)

			%compute number of labels
			numlabels=min(options_structure.showsection,length(s));
			shift=fix(length(x)/numlabels);

			%plot labels on current graph
			hold on
			text(x(1),y(1),z(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(x(1+(i-1)*shift),y(1+(i-1)*shift),z(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(x(end),y(end),z(end),'end','backgroundcolor',[0.8 0.9 0.8])

			%plot section only with labels
			subplot(width,width,index2)
			plot_unit(x_m,y_m,z_m,elements_m,data,isongrid,is2d,isquiver,options_structure)
			hold on
			text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
			plot(x,y,'-r')
			axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
			view(2)
		end

		subplot(width,width,index1)
		A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
		patch( 'Faces', [A B C D], 'Vertices', [x y z],'FaceVertexCData',data_s,'FaceColor','interp','EdgeColor','none');
		view(3)

	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Section value';
end 
if isnan(options_structure.colorbar) & strcmpi(md.type,'2d')
	options_structure.colorbar=0;
end
if isnan(options_structure.xlabel) & (strcmpi(md.type,'2d') | options_structure.view==2 )
	options_structure.xlabel='Curvilinear coordinate';
end
if isnan(options_structure.ylabel) & (strcmpi(md.type,'3d') & options_structure.view==2 )
	options_structure.ylabel='z';
end
applyoptions(md,[],options_structure);
